/*
 * Decompiled with CFR 0.152.
 */
package net.werdei.biome_replacer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.werdei.biome_replacer.config.Config;
import net.werdei.biome_replacer.replacer.VanillaReplacer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeReplacer {
    private static final Logger LOGGER = LogManager.getLogger(BiomeReplacer.class);
    private static final String LOG_PREFIX = "[BiomeReplacer] ";
    private static final List<Warning> unshownWarnings = new ArrayList<Warning>();

    public static void initialize() {
        Config.getOrCreateFile();
    }

    public static void doReplacement(Registry<Biome> biomeRegistry, Registry<LevelStem> stemRegistry) {
        Config.reload();
        VanillaReplacer.doReplacement(biomeRegistry, stemRegistry);
    }

    public static void debug(String message) {
        LOGGER.debug("[BiomeReplacer] {}", (Object)message);
    }

    public static void log(String message) {
        LOGGER.info("[BiomeReplacer] {}", (Object)message);
    }

    public static void logWarn(String message) {
        LOGGER.warn("[BiomeReplacer] {}", (Object)message);
    }

    public static void logRuleWarning(int line, String message) {
        unshownWarnings.add(new Warning(line, message));
        LOGGER.warn("{}Config issue on line {}: {}", (Object)LOG_PREFIX, (Object)line, (Object)message);
    }

    public static void showWarnings(ServerPlayer player) {
        if (unshownWarnings.isEmpty()) {
            return;
        }
        try {
            unshownWarnings.sort(Comparator.comparingInt(w -> w.line));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76[BiomeReplacer] There are issues in the configuration file:"));
            for (Warning warning : unshownWarnings) {
                player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a76Line %s:\u00a7r %s", warning.line, warning.message)));
            }
        }
        catch (NoSuchMethodError e) {
            BiomeReplacer.logWarn("Failed to show config warnings in chat, you're probably running 1.18.2 where it's not supported.");
        }
        unshownWarnings.clear();
    }

    public record Warning(int line, String message) {
    }
}

