/*
 * Decompiled with CFR 0.152.
 */
package net.werdei.biome_replacer.replacer;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.werdei.biome_replacer.replacer.VanillaReplacer;

public final class BlueprintReplacer {
    private static final ResourceKey<Biome> ORIGINAL_SOURCE_MARKER_KEY = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)"blueprint:original_source_marker")));
    private static final Map<BiomeSource, String> DIMENSION_BY_SOURCE = new ConcurrentHashMap<BiomeSource, String>();
    private static final ThreadLocal<String> DIMENSION_CONTEXT = new ThreadLocal();

    private BlueprintReplacer() {
    }

    public static void pushDimensionContext(String dimensionId) {
        if (dimensionId == null || dimensionId.isEmpty()) {
            DIMENSION_CONTEXT.remove();
            return;
        }
        DIMENSION_CONTEXT.set(dimensionId);
    }

    public static void captureDimensionFor(BiomeSource source) {
        String dimensionId = DIMENSION_CONTEXT.get();
        DIMENSION_CONTEXT.remove();
        if (dimensionId != null && source != null) {
            DIMENSION_BY_SOURCE.put(source, dimensionId);
        }
    }

    public static Holder<Biome> adjustBiome(Holder<Biome> original, Registry<Biome> registry, BiomeSource source) {
        if (registry == null) {
            return original;
        }
        if (original == null) {
            return BlueprintReplacer.originalSourceMarker(registry);
        }
        String dimensionId = source != null ? DIMENSION_BY_SOURCE.get(source) : null;
        Holder<Biome> replaced = VanillaReplacer.replaceIfNeeded(original, dimensionId);
        return replaced != null ? replaced : BlueprintReplacer.originalSourceMarker(registry);
    }

    private static Holder<Biome> originalSourceMarker(Registry<Biome> registry) {
        return registry.getHolderOrThrow(ORIGINAL_SOURCE_MARKER_KEY);
    }
}

