/*
 * Decompiled with CFR 0.152.
 */
package net.werdei.biome_replacer;

import java.util.List;
import java.util.Set;
import net.werdei.biome_replacer.BiomeReplacer;
import net.werdei.biome_replacer.Platform;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    private static final String TERRABLENDER_ID = "terrablender";
    private static final String BLUEPRINT_ID = "blueprint";
    private String ownPackage;
    private boolean terrablenderInstalled;
    private boolean blueprintInstalled;

    public void onLoad(String mixinPackage) {
        this.ownPackage = mixinPackage;
        this.terrablenderInstalled = Platform.isModLoaded(TERRABLENDER_ID);
        this.blueprintInstalled = Platform.isModLoaded(BLUEPRINT_ID);
        if (this.terrablenderInstalled) {
            BiomeReplacer.log("TerraBlender detected, biome replacements will be injected into it");
        }
        if (this.blueprintInstalled) {
            BiomeReplacer.log("Blueprint detected, biome replacements will be injected into it");
        }
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String mixinShortName = mixinClassName.substring(this.ownPackage.length() + 1);
        if (mixinShortName.startsWith(TERRABLENDER_ID)) {
            return this.terrablenderInstalled;
        }
        if (mixinShortName.startsWith(BLUEPRINT_ID)) {
            return this.blueprintInstalled;
        }
        return true;
    }

    public String getRefMapperConfig() {
        return null;
    }

    public List<String> getMixins() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

