/*
 * Decompiled with CFR 0.152.
 */
package net.flare.soulsmp;

import java.io.File;
import net.flare.soulsmp.commands.SoulSMPReloadCommand;
import net.flare.soulsmp.commands.SoulWithdrawCommand;
import net.flare.soulsmp.listeners.PlayerDeathListener;
import net.flare.soulsmp.listeners.PlayerInteractListener;
import net.flare.soulsmp.listeners.PlayerJoinListener;
import net.flare.soulsmp.managers.BanManager;
import net.flare.soulsmp.managers.SoulItemManager;
import net.flare.soulsmp.managers.SoulManager;
import net.flare.soulsmp.utils.ActionBarUtil;
import net.flare.soulsmp.utils.ConfigUtil;
import net.flare.soulsmp.utils.DataStorageUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SoulSMP
extends JavaPlugin {
    private SoulManager soulManager;
    private SoulItemManager soulItemManager;
    private BanManager banManager;
    private ActionBarUtil actionBarUtil;
    private DataStorageUtil dataStorageUtil;

    public void onEnable() {
        this.saveDefaultConfig();
        this.soulItemManager = new SoulItemManager();
        this.banManager = new BanManager();
        this.actionBarUtil = new ActionBarUtil();
        this.dataStorageUtil = new DataStorageUtil(new File(this.getDataFolder(), "souls.yml"));
        this.soulManager = new SoulManager(this.dataStorageUtil, this.banManager, this.actionBarUtil);
        ConfigUtil.loadConfigValues(this.getConfig(), this.soulManager, this.soulItemManager);
        this.loadActionBarSettings();
        this.registerListeners();
        this.registerCommands();
        this.getLogger().info("SoulSMP enabled.");
    }

    public void onDisable() {
        this.saveSouls();
        this.getLogger().info("SoulSMP disabled.");
    }

    public void saveSouls() {
    }

    private void loadActionBarSettings() {
        if (this.getConfig().getConfigurationSection("display.actionbar") != null) {
            this.actionBarUtil.setEnabled(this.getConfig().getBoolean("display.actionbar.enabled", true));
            this.actionBarUtil.setActionBarText(this.getConfig().getString("display.actionbar.text", "&cSouls: {souls}"));
        }
    }

    private void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerDeathListener(this.soulManager, this.soulItemManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerInteractListener(this.soulManager, this.soulItemManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(this.soulManager, this.actionBarUtil), (Plugin)this);
    }

    private void registerCommands() {
        this.getCommand("soulwithdraw").setExecutor((CommandExecutor)new SoulWithdrawCommand(this.soulManager, this.soulItemManager, this.banManager));
        this.getCommand("soulsmpreload").setExecutor((CommandExecutor)new SoulSMPReloadCommand(this));
    }
}

