/*
 * Decompiled with CFR 0.152.
 */
package net.flare.soulsmp.commands;

import net.flare.soulsmp.managers.BanManager;
import net.flare.soulsmp.managers.SoulItemManager;
import net.flare.soulsmp.managers.SoulManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SoulWithdrawCommand
implements CommandExecutor {
    private final SoulManager soulManager;
    private final SoulItemManager soulItemManager;
    private final BanManager banManager;

    public SoulWithdrawCommand(SoulManager soulManager, SoulItemManager soulItemManager, BanManager banManager) {
        this.soulManager = soulManager;
        this.soulItemManager = soulItemManager;
        this.banManager = banManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /soulwithdraw <amount>");
            return true;
        }
        try {
            amount = Integer.parseInt(args[0]);
            if (amount <= 0) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Please enter a positive number.");
                return true;
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number.");
            return true;
        }
        int currentSouls = this.soulManager.getSouls(player);
        if (currentSouls < amount) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have enough souls to withdraw that amount.");
            return true;
        }
        this.soulManager.removeSouls(player, amount);
        ItemStack soulItem = this.soulItemManager.createSoulItem();
        soulItem.setAmount(amount);
        player.getInventory().addItem(new ItemStack[]{soulItem});
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have withdrawn " + amount + " soul(s).");
        if (this.soulManager.getSouls(player) <= 0) {
            this.banManager.banPlayer(player, "You have run out of souls!");
        }
        return true;
    }
}

