/*
 * Decompiled with CFR 0.152.
 */
package net.flare.soulsmp.listeners;

import net.flare.soulsmp.managers.SoulItemManager;
import net.flare.soulsmp.managers.SoulManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerDeathListener
implements Listener {
    private final SoulManager soulManager;
    private final SoulItemManager soulItemManager;

    public PlayerDeathListener(SoulManager soulManager, SoulItemManager soulItemManager) {
        this.soulManager = soulManager;
        this.soulItemManager = soulItemManager;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        if (killer == null) {
            return;
        }
        int soulsLost = this.soulManager.getLoseOnDeathByPlayer();
        int victimSouls = this.soulManager.getSouls(victim);
        if (victimSouls <= 0) {
            return;
        }
        int newSouls = Math.max(victimSouls - soulsLost, 0);
        this.soulManager.setSouls(victim, newSouls);
        if (newSouls < victimSouls) {
            ItemStack soulItem = this.soulItemManager.createSoulItem();
            soulItem.setAmount(soulsLost);
            victim.getWorld().dropItemNaturally(victim.getLocation(), soulItem);
        }
        if (newSouls == 0 && this.soulManager.isBanOnZero()) {
            this.soulManager.getBanManager().banPlayer(victim, "You have run out of souls!");
        }
        this.soulManager.getActionBarUtil().sendSoulActionBar(victim);
        this.soulManager.getActionBarUtil().sendSoulActionBar(killer);
    }
}

