/*
 * Decompiled with CFR 0.152.
 */
package net.flare.soulsmp.listeners;

import net.flare.soulsmp.managers.SoulItemManager;
import net.flare.soulsmp.managers.SoulManager;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PlayerInteractListener
implements Listener {
    private final SoulManager soulManager;
    private final SoulItemManager soulItemManager;

    public PlayerInteractListener(SoulManager soulManager, SoulItemManager soulItemManager) {
        this.soulManager = soulManager;
        this.soulItemManager = soulItemManager;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.hasItem()) {
            return;
        }
        if (event.getHand() != null && event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (!this.soulItemManager.isSoulItem(item)) {
            return;
        }
        event.setCancelled(true);
        int currentSouls = this.soulManager.getSouls(player);
        int maxSouls = this.soulManager.getMaxSouls();
        if (currentSouls >= maxSouls) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You already have the maximum number of souls.");
            return;
        }
        this.soulManager.addSouls(player, 1);
        item.setAmount(item.getAmount() - 1);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You absorbed a soul! Souls: " + this.soulManager.getSouls(player));
        this.soulManager.getActionBarUtil().sendSoulActionBar(player);
    }
}

