/*
 * Decompiled with CFR 0.152.
 */
package net.flare.soulsmp.managers;

import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SoulItemManager {
    private Material material = Material.NETHER_STAR;
    private int customModelData = 100;
    private String displayName = String.valueOf(ChatColor.GOLD) + "Soul";
    private List<String> lore = List.of(String.valueOf(ChatColor.GRAY) + "A player's soul.", String.valueOf(ChatColor.WHITE) + "Right-click to absorb soul.");

    public ItemStack createSoulItem() {
        ItemStack item = new ItemStack(this.material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setCustomModelData(Integer.valueOf(this.customModelData));
            meta.displayName((Component)Component.text((String)this.displayName));
            meta.lore(this.lore.stream().map(Component::text).toList());
            item.setItemMeta(meta);
        }
        return item;
    }

    public boolean isSoulItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        if (item.getType() != this.material) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta != null && meta.hasCustomModelData() && meta.getCustomModelData() == this.customModelData;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }
}

