/*
 * Decompiled with CFR 0.152.
 */
package net.flare.soulsmp.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.flare.soulsmp.managers.BanManager;
import net.flare.soulsmp.utils.ActionBarUtil;
import net.flare.soulsmp.utils.DataStorageUtil;
import org.bukkit.entity.Player;

public class SoulManager {
    private final Map<UUID, Integer> playerSouls = new HashMap<UUID, Integer>();
    private final DataStorageUtil dataStorageUtil;
    private final BanManager banManager;
    private final ActionBarUtil actionBarUtil;
    private int defaultSouls = 3;
    private int maxSouls = 5;
    private int loseOnDeathByPlayer = 1;
    private boolean banOnZero = true;

    public SoulManager(DataStorageUtil dataStorageUtil, BanManager banManager, ActionBarUtil actionBarUtil) {
        this.dataStorageUtil = dataStorageUtil;
        this.banManager = banManager;
        this.actionBarUtil = actionBarUtil;
        this.loadData();
    }

    public int getSouls(Player player) {
        return this.playerSouls.getOrDefault(player.getUniqueId(), this.defaultSouls);
    }

    public void setSouls(Player player, int souls) {
        this.playerSouls.put(player.getUniqueId(), souls);
        this.saveData();
    }

    public void addSouls(Player player, int amount) {
        int newSouls = Math.min(this.getSouls(player) + amount, this.maxSouls);
        this.setSouls(player, newSouls);
    }

    public void removeSouls(Player player, int amount) {
        int newSouls = Math.max(this.getSouls(player) - amount, 0);
        this.setSouls(player, newSouls);
    }

    public boolean hasData(Player player) {
        return this.playerSouls.containsKey(player.getUniqueId());
    }

    public int getDefaultSouls() {
        return this.defaultSouls;
    }

    public void setDefaultSouls(int defaultSouls) {
        this.defaultSouls = defaultSouls;
    }

    public int getMaxSouls() {
        return this.maxSouls;
    }

    public void setMaxSouls(int maxSouls) {
        this.maxSouls = maxSouls;
    }

    public int getLoseOnDeathByPlayer() {
        return this.loseOnDeathByPlayer;
    }

    public void setLoseOnDeathByPlayer(int loseOnDeathByPlayer) {
        this.loseOnDeathByPlayer = loseOnDeathByPlayer;
    }

    public boolean isBanOnZero() {
        return this.banOnZero;
    }

    public void setBanOnZero(boolean banOnZero) {
        this.banOnZero = banOnZero;
    }

    public BanManager getBanManager() {
        return this.banManager;
    }

    public ActionBarUtil getActionBarUtil() {
        return this.actionBarUtil;
    }

    private void loadData() {
        Map<UUID, Integer> loaded = this.dataStorageUtil.loadSouls();
        this.playerSouls.clear();
        this.playerSouls.putAll(loaded);
    }

    private void saveData() {
        this.dataStorageUtil.saveSouls(this.playerSouls);
    }

    public boolean isActionBarEnabled() {
        return true;
    }
}

