/*
 * Decompiled with CFR 0.152.
 */
package net.flare.soulsmp.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataStorageUtil {
    private final File dataFile;
    private final YamlConfiguration yml;

    public DataStorageUtil(File dataFile) {
        this.dataFile = dataFile;
        if (!dataFile.exists()) {
            try {
                dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.yml = YamlConfiguration.loadConfiguration((File)dataFile);
    }

    public Map<UUID, Integer> loadSouls() {
        HashMap<UUID, Integer> souls = new HashMap<UUID, Integer>();
        for (String key : this.yml.getKeys(false)) {
            UUID uuid;
            try {
                uuid = UUID.fromString(key);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            souls.put(uuid, this.yml.getInt(key));
        }
        return souls;
    }

    public void saveSouls(Map<UUID, Integer> souls) {
        for (Map.Entry<UUID, Integer> entry : souls.entrySet()) {
            this.yml.set(entry.getKey().toString(), (Object)entry.getValue());
        }
        try {
            this.yml.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

