/*
 * Decompiled with CFR 0.152.
 */
package com.funnyboyroks.drawers;

import com.funnyboyroks.drawers.Drawers;
import com.funnyboyroks.drawers.Util;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Barrel;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class DrawerBlock {
    public Block block;
    public ItemDisplay itemDisplay;
    public TextDisplay textDisplay;
    public DrawerState state;

    public DrawerBlock(Block block, ItemDisplay itemDisplay, TextDisplay textDisplay, DrawerState state) {
        this.block = block;
        this.itemDisplay = itemDisplay;
        this.textDisplay = textDisplay;
        this.state = state;
    }

    public Barrel getBlockData() {
        return (Barrel)this.block.getBlockData();
    }

    public boolean hasType() {
        return this.state.item() != null;
    }

    public boolean isEmpty() {
        return !this.hasType() || this.state.count() == 0;
    }

    public boolean isInfinite() {
        return this.state.count() == -1;
    }

    public int capacity() {
        return Drawers.config().max_stack_count;
    }

    public int maxCount() {
        return this.state.item().getMaxStackSize() * this.capacity();
    }

    @NotNull
    public Optional<ItemStack> add(ItemStack stack) {
        if (this.isInfinite()) {
            return Optional.empty();
        }
        if (this.hasType()) {
            if (!stack.isSimilar(this.state.item()) || this.state.count() > this.maxCount()) {
                return Optional.of(stack);
            }
            int newCount = this.state.count() + stack.getAmount();
            int maxCap = this.maxCount();
            ItemStack overflow = null;
            if (newCount > maxCap && !this.state.voidExcess()) {
                int overflowQty = newCount % maxCap;
                overflow = stack.asQuantity(overflowQty);
            }
            this.state = this.state.withCount(Math.max(this.state.count(), Math.min(newCount, maxCap)));
            return Optional.ofNullable(overflow);
        }
        this.state = this.state.withItem(stack.clone()).withCount(stack.getAmount());
        return Optional.empty();
    }

    @Nullable
    public ItemStack removeItem(boolean fullStack) {
        int actual;
        DrawerState nextState;
        int desired;
        if (!this.hasType()) {
            return null;
        }
        int n = desired = fullStack ? this.state.item().getMaxStackSize() : 1;
        if (this.isInfinite()) {
            nextState = this.state;
            actual = desired;
        } else if (this.state.count() > desired) {
            nextState = this.state.withCount(this.state.count() - desired);
            actual = desired;
        } else {
            nextState = new DrawerState();
            actual = this.state.count();
        }
        ItemStack out = this.state.item().clone();
        out.setAmount(actual);
        this.state = nextState;
        return out;
    }

    private Component displayText() {
        return switch (this.state.count()) {
            case -1 -> MiniMessage.builder().build().deserialize((Object)Drawers.lang().infinite);
            case 0 -> MiniMessage.builder().build().deserialize((Object)Drawers.lang().empty);
            default -> MiniMessage.builder().build().deserialize((Object)Drawers.lang().quantity.formatted(this.state.count()));
        };
    }

    public void updateDisplay() {
        this.textDisplay.text(this.displayText());
        this.itemDisplay.setItemStack(this.state.item());
    }

    public void saveData() {
        if (this.block.getType() != Material.BARREL) {
            Drawers.instance().getLogger().warning("Tried to save data of block that is not a barrel at " + Util.format(this.block.getLocation()) + ".");
            return;
        }
        Drawers.dataHandler().data.locations.add(this.block.getLocation());
        org.bukkit.block.Barrel barrel = (org.bukkit.block.Barrel)this.block.getState();
        PersistentDataContainer pdc = barrel.getPersistentDataContainer();
        pdc.set(Util.ns("is_drawer"), PersistentDataType.BOOLEAN, (Object)true);
        pdc.set(Util.ns("item_display"), PersistentDataType.LONG_ARRAY, (Object)Util.uuidToLongArr(this.itemDisplay.getUniqueId()));
        pdc.set(Util.ns("text_display"), PersistentDataType.LONG_ARRAY, (Object)Util.uuidToLongArr(this.textDisplay.getUniqueId()));
        this.state.toPdc(pdc);
        barrel.update();
    }

    @NotNull
    public static Optional<DrawerBlock> fromBlock(@NotNull Block block) {
        if (block.getType() != Material.BARREL) {
            Drawers.instance().getLogger().warning("Tried to load data of block that is not a barrel at " + Util.format(block.getLocation()) + ".");
            return Optional.empty();
        }
        org.bukkit.block.Barrel barrel = (org.bukkit.block.Barrel)block.getState();
        PersistentDataContainer pdc = barrel.getPersistentDataContainer();
        boolean isDrawer = (Boolean)pdc.getOrDefault(Util.ns("is_drawer"), PersistentDataType.BOOLEAN, (Object)false);
        if (!isDrawer) {
            return Optional.empty();
        }
        UUID item = Util.longArrToUUID((long[])pdc.get(Util.ns("item_display"), PersistentDataType.LONG_ARRAY));
        UUID text = Util.longArrToUUID((long[])pdc.get(Util.ns("text_display"), PersistentDataType.LONG_ARRAY));
        Entity entity = block.getWorld().getEntity(item);
        ItemDisplay itemDisplay = null;
        if (entity == null) {
            Drawers.instance().getLogger().warning("Item display is missing for drawer at " + Util.format(block.getLocation()) + ".");
        } else if (entity instanceof ItemDisplay) {
            ItemDisplay id;
            itemDisplay = id = (ItemDisplay)entity;
        } else {
            Drawers.instance().getLogger().warning("Item display entity is not an ItemDisplay for drawer at " + Util.format(block.getLocation()) + ".");
            itemDisplay = null;
        }
        entity = block.getWorld().getEntity(text);
        TextDisplay textDisplay = null;
        if (entity == null) {
            Drawers.instance().getLogger().warning("Text display is missing for drawer at " + Util.format(block.getLocation()) + ".");
        } else if (entity instanceof TextDisplay) {
            TextDisplay td;
            textDisplay = td = (TextDisplay)entity;
        } else {
            Drawers.instance().getLogger().warning("Text display entity is not an TextDisplay for drawer at " + Util.format(block.getLocation()) + ".");
            textDisplay = null;
        }
        DrawerState state = DrawerState.fromPdc(pdc);
        return Optional.of(new DrawerBlock(block, itemDisplay, textDisplay, state));
    }

    public void dropContents() {
        if (this.isEmpty() || this.isInfinite()) {
            return;
        }
        int stackSize = this.state.item().getMaxStackSize();
        int stacks = this.state.count() / stackSize;
        Location summonAt = this.block.getLocation().clone().add(0.5, 0.5, 0.5);
        ItemStack fullStack = this.state.item().asQuantity(stackSize);
        for (int i = 0; i < stacks; ++i) {
            this.block.getWorld().dropItemNaturally(summonAt, fullStack);
        }
        if (this.state.count() % stackSize != 0) {
            this.block.getWorld().dropItemNaturally(summonAt, fullStack.asQuantity(this.state.count() % stackSize));
        }
        Drawers.dataHandler().data.locations.remove(this.block.getLocation());
    }

    public record DrawerState(@Nullable ItemStack item, int count, boolean voidExcess) {
        public DrawerState() {
            this(null, 0, false);
        }

        public DrawerState withCount(int count) {
            return new DrawerState(this.item(), count, this.voidExcess());
        }

        public DrawerState withItem(@Nullable ItemStack stack) {
            return new DrawerState(stack, this.count(), this.voidExcess());
        }

        public void toPdc(@NotNull PersistentDataContainer pdc) {
            if (this.item() == null) {
                pdc.remove(Util.ns("item_stack"));
            } else {
                pdc.set(Util.ns("item_stack"), PersistentDataType.BYTE_ARRAY, (Object)this.item().serializeAsBytes());
            }
            if (this.count() == 0) {
                pdc.remove(Util.ns("count"));
            } else {
                pdc.set(Util.ns("count"), PersistentDataType.INTEGER, (Object)this.count());
            }
            pdc.set(Util.ns("void"), PersistentDataType.BOOLEAN, (Object)this.voidExcess());
        }

        @NotNull
        public static DrawerState fromPdc(@NotNull PersistentDataContainer pdc) {
            NamespacedKey isKey = Util.ns("item_stack");
            byte[] isSer = (byte[])pdc.getOrDefault(isKey, PersistentDataType.BYTE_ARRAY, (Object)new byte[0]);
            ItemStack item = isSer.length == 0 ? null : ItemStack.deserializeBytes((byte[])isSer);
            return new DrawerState(item, (Integer)pdc.getOrDefault(Util.ns("count"), PersistentDataType.INTEGER, (Object)0), (Boolean)pdc.getOrDefault(Util.ns("void"), PersistentDataType.BOOLEAN, (Object)false));
        }
    }
}

