/*
 * Decompiled with CFR 0.152.
 */
package com.funnyboyroks.drawers;

import com.funnyboyroks.drawers.Listeners;
import com.funnyboyroks.drawers.Util;
import com.funnyboyroks.drawers.data.Config;
import com.funnyboyroks.drawers.data.DataHandler;
import com.funnyboyroks.drawers.data.Lang;
import de.exlll.configlib.YamlConfigurations;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Drawers
extends JavaPlugin {
    private static Drawers INSTANCE;
    private Config config;
    private Lang lang;
    private DataHandler dataHandler;

    public static Drawers instance() {
        return INSTANCE;
    }

    public static Config config() {
        return Drawers.instance().config;
    }

    public static Lang lang() {
        return Drawers.instance().lang;
    }

    public static DataHandler dataHandler() {
        return Drawers.instance().dataHandler;
    }

    public Drawers() {
        INSTANCE = this;
    }

    public void onEnable() {
        Path configPath = Paths.get(this.getDataPath().toString(), "config.yml");
        this.config = YamlConfigurations.update(configPath, Config.class);
        Path langPath = Paths.get(this.getDataPath().toString(), "lang.yml");
        this.lang = YamlConfigurations.update(langPath, Lang.class);
        this.getLogger().info("Loaded Config");
        this.dataHandler = new DataHandler();
        try {
            this.dataHandler.loadData(this);
        }
        catch (IOException ex) {
            this.getLogger().severe("Unable to load plugin data: " + String.valueOf(ex));
            this.getLogger().severe("Disabling plugin");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            try {
                this.dataHandler.saveData();
            }
            catch (IOException ex) {
                this.getLogger().severe("Unable to save plugin data: " + String.valueOf(ex));
            }
        }, 6000L, 6000L);
        this.getServer().getPluginManager().registerEvents((Listener)new Listeners(), (Plugin)this);
        this.addRecipes();
        this.getLogger().info("Registered Recipes");
    }

    public void addRecipes() {
        this.getServer().addRecipe(this.config.drawer_recipe.recipe(Util.ns("drawer_recipe")));
    }

    public void onDisable() {
        try {
            this.dataHandler.saveData();
        }
        catch (IOException ex) {
            this.getLogger().severe("Unable to save plugin data: " + String.valueOf(ex));
        }
    }
}

