/*
 * Decompiled with CFR 0.152.
 */
package com.funnyboyroks.drawers;

import com.funnyboyroks.drawers.DrawerBlock;
import com.funnyboyroks.drawers.Util;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.ExplosionResult;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Listeners
implements Listener {
    private static final AxisAngle4f[] ANGLES = new AxisAngle4f[]{new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f), new AxisAngle4f(-1.5707964f, 0.0f, 1.0f, 0.0f), new AxisAngle4f((float)Math.PI, 0.0f, 1.0f, 0.0f), new AxisAngle4f(1.5707964f, 0.0f, 1.0f, 0.0f), new AxisAngle4f(1.5707964f, 1.0f, 0.0f, 0.0f), new AxisAngle4f(-1.5707964f, 1.0f, 0.0f, 0.0f)};
    private static final AxisAngle4f[] OPPOSING_ANGLES = new AxisAngle4f[]{new AxisAngle4f((float)Math.PI, 0.0f, 1.0f, 0.0f), new AxisAngle4f(1.5707964f, 0.0f, 1.0f, 0.0f), new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f), new AxisAngle4f(-1.5707964f, 0.0f, 1.0f, 0.0f), new AxisAngle4f(1.5707964f, 1.0f, 0.0f, 0.0f), new AxisAngle4f(-1.5707964f, 1.0f, 0.0f, 0.0f)};

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.BARREL) {
            return;
        }
        CustomModelData modelData = (CustomModelData)event.getItemInHand().getData(DataComponentTypes.CUSTOM_MODEL_DATA);
        if (modelData == null || !modelData.strings().contains(Util.ns("barrel").toString())) {
            return;
        }
        Directional dir = (Directional)block.getBlockData();
        ItemDisplay item = (ItemDisplay)block.getWorld().spawn(block.getLocation().add(0.5, 0.5, 0.5), ItemDisplay.class, entity -> {
            entity.setBrightness(new Display.Brightness(15, 15));
            entity.setTransformationMatrix(new Matrix4f().rotate(ANGLES[dir.getFacing().ordinal()]).translate(0.0f, 0.125f, -0.5f).scale((Vector3fc)new Vector3f(0.5f, 0.5f, 0.1f)));
        });
        TextDisplay text = (TextDisplay)block.getWorld().spawn(block.getLocation().add(0.5, 0.5, 0.5), TextDisplay.class, entity -> {
            entity.setBrightness(new Display.Brightness(15, 15));
            entity.setBackgroundColor(Color.fromARGB((int)0));
            Matrix4f transformation = new Matrix4f().rotate(OPPOSING_ANGLES[dir.getFacing().ordinal()]);
            if (dir.getFacing().getModY() != 0) {
                transformation = transformation.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
            }
            transformation = transformation.translate(0.0f, -0.375f, 0.5f).scale(0.75f);
            entity.setTransformationMatrix(transformation);
        });
        DrawerBlock drawer = new DrawerBlock(block, item, text, new DrawerBlock.DrawerState());
        drawer.updateDisplay();
        drawer.saveData();
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.BARREL) {
            return;
        }
        Optional<DrawerBlock> optDrawer = DrawerBlock.fromBlock(block);
        if (optDrawer.isEmpty()) {
            return;
        }
        DrawerBlock drawer = optDrawer.get();
        drawer.dropContents();
        if (event.isDropItems()) {
            event.setDropItems(false);
            drawer.block.getWorld().dropItemNaturally(drawer.block.getLocation().clone().add(0.5, 0.5, 0.5), Util.drawerItem());
        }
        Util.tryRemoveEntity((Entity)drawer.itemDisplay);
        Util.tryRemoveEntity((Entity)drawer.textDisplay);
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        for (Block block : event.blockList()) {
            if (block.getType() != Material.BARREL) {
                return;
            }
            Optional<DrawerBlock> optDrawer = DrawerBlock.fromBlock(block);
            if (optDrawer.isEmpty()) {
                return;
            }
            DrawerBlock drawer = optDrawer.get();
            drawer.dropContents();
            Util.tryRemoveEntity((Entity)drawer.itemDisplay);
            Util.tryRemoveEntity((Entity)drawer.textDisplay);
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        for (Block block : event.blockList()) {
            if (block.getType() != Material.BARREL) {
                return;
            }
            Optional<DrawerBlock> optDrawer = DrawerBlock.fromBlock(block);
            if (optDrawer.isEmpty()) {
                return;
            }
            DrawerBlock drawer = optDrawer.get();
            drawer.dropContents();
            block.setType(Material.AIR);
            if (event.getExplosionResult() == ExplosionResult.DESTROY || event.getExplosionResult() == ExplosionResult.DESTROY_WITH_DECAY) {
                drawer.block.getWorld().dropItemNaturally(drawer.block.getLocation().clone().add(0.5, 0.5, 0.5), Util.drawerItem());
            }
            Util.tryRemoveEntity((Entity)drawer.itemDisplay);
            Util.tryRemoveEntity((Entity)drawer.textDisplay);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.BARREL) {
            return;
        }
        Optional<DrawerBlock> optDrawer = DrawerBlock.fromBlock(block);
        if (optDrawer.isEmpty()) {
            return;
        }
        DrawerBlock drawer = optDrawer.get();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemStack is = event.getItem();
            if (event.getPlayer().isSneaking() && is != null) {
                return;
            }
            if (event.getBlockFace() == drawer.getBlockData().getFacing() && is != null) {
                Optional<ItemStack> overflowOpt = drawer.add(is);
                event.getPlayer().getInventory().setItem(event.getHand(), overflowOpt.isPresent() ? overflowOpt.get() : null);
                drawer.saveData();
                drawer.updateDisplay();
            }
            event.setCancelled(true);
        } else if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            if (drawer.isEmpty()) {
                return;
            }
            if (event.getBlockFace() != drawer.getBlockData().getFacing()) {
                return;
            }
            ItemStack stack = drawer.removeItem(event.getPlayer().isSneaking());
            if (stack != null) {
                event.getPlayer().give(new ItemStack[]{stack});
            }
            drawer.saveData();
            drawer.updateDisplay();
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryMove(InventoryMoveItemEvent event) {
        Optional<DrawerBlock> optDrawer;
        Block block;
        Optional<DrawerBlock> optDrawer2;
        Block block2;
        Inventory dest = event.getDestination();
        Location destLoc = dest.getLocation();
        if (destLoc != null && (block2 = destLoc.getBlock()) != null && block2.getType() == Material.BARREL && (optDrawer2 = DrawerBlock.fromBlock(block2)).isPresent()) {
            ItemStack stack2;
            DrawerBlock drawer = optDrawer2.get();
            Optional<ItemStack> overflowOpt = drawer.add(stack2 = event.getItem());
            if (overflowOpt.isEmpty() || !overflowOpt.get().equals((Object)stack2)) {
                event.setItem(new ItemStack(Material.AIR));
                drawer.saveData();
                drawer.updateDisplay();
            } else {
                event.setCancelled(true);
            }
            return;
        }
        Inventory src = event.getSource();
        Location srcLoc = src.getLocation();
        if (srcLoc != null && (block = srcLoc.getBlock()) != null && block.getType() == Material.BARREL && (optDrawer = DrawerBlock.fromBlock(block)).isPresent()) {
            DrawerBlock drawer = optDrawer.get();
            if (dest.firstEmpty() == -1 && Arrays.stream(dest.getContents()).noneMatch(stack -> stack.getAmount() < stack.getMaxStackSize())) {
                return;
            }
            drawer.removeItem(false);
            drawer.saveData();
            drawer.updateDisplay();
        }
    }

    @EventHandler
    public void onHopperSearch(HopperInventorySearchEvent event) {
        Block block = event.getSearchBlock();
        if (block == null || block.getType() != Material.BARREL) {
            return;
        }
        Optional<DrawerBlock> optDrawer = DrawerBlock.fromBlock(block);
        if (optDrawer.isEmpty()) {
            return;
        }
        DrawerBlock drawer = optDrawer.get();
        Inventory newInv = Bukkit.createInventory((InventoryHolder)event.getInventory().getHolder(), (int)9);
        if (!drawer.isEmpty()) {
            newInv.setItem(0, drawer.state.item().asOne());
        }
        event.setInventory(newInv);
    }
}

