/*
 * Decompiled with CFR 0.152.
 */
package com.funnyboyroks.drawers.data;

import com.funnyboyroks.drawers.Util;
import com.google.common.collect.ImmutableMap;
import de.exlll.configlib.Comment;
import de.exlll.configlib.Configuration;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.recipe.CraftingBookCategory;

@Configuration
public class Config {
    @Comment(value={"The maximum number of stacks that may be stored in a base drawer.", "Example: if max_stack_count = 32, then a cobblestone drawer may store up to 2048 items", "         and an ender pearl drawer may store up to 512 items."})
    public int max_stack_count = 32;
    @Comment(value={"", "The recipe used to create the drawer item"})
    public RecipeConfig drawer_recipe = new RecipeConfig();

    public String toString() {
        return "Config[max_stack_count=%d]".formatted(this.max_stack_count);
    }

    @Configuration
    public static class RecipeConfig {
        @Comment(value={"Whether this recipe is shaped"})
        public boolean shaped = true;
        @Comment(value={"The pattern for the recipe.  Each slot should be represented by a single character that is defined in the `key`"})
        public String[] pattern = new String[]{"AAA", "ABA", "AAA"};
        @Comment(value={"Keys for the recipe.  Each item should be one character and map to an item.  You can use item ids or tags: minecraft:stone or #planks"})
        public Map<Character, String> key = new ImmutableMap.Builder().put((Object)Character.valueOf('A'), (Object)"#planks").put((Object)Character.valueOf('B'), (Object)"minecraft:chest").build();

        public Recipe recipe(NamespacedKey key) {
            Map<Character, RecipeChoice> resolvedKey = this.key.entrySet().stream().map(entry -> {
                String item = (String)entry.getValue();
                return new Pair<Character, RecipeChoice.MaterialChoice>((Character)entry.getKey(), item.startsWith("#") ? new RecipeChoice.MaterialChoice(Util.getTag(item.substring(1))) : new RecipeChoice.MaterialChoice(Material.matchMaterial((String)item)));
            }).collect(Collectors.toUnmodifiableMap(e -> (Character)e.first(), e -> (RecipeChoice)e.second()));
            if (this.shaped) {
                ShapedRecipe shaped = new ShapedRecipe(key, Util.drawerItem());
                shaped.shape(this.pattern);
                shaped.setCategory(CraftingBookCategory.MISC);
                for (Map.Entry<Character, RecipeChoice> entry2 : resolvedKey.entrySet()) {
                    shaped.setIngredient(entry2.getKey().charValue(), entry2.getValue());
                }
                return shaped;
            }
            ShapelessRecipe shapeless = new ShapelessRecipe(key, Util.drawerItem());
            shapeless.setCategory(CraftingBookCategory.MISC);
            for (String line : this.pattern) {
                for (char c : line.trim().toCharArray()) {
                    shapeless.addIngredient(resolvedKey.get(Character.valueOf(c)));
                }
            }
            return shapeless;
        }

        private record Pair<A, B>(A first, B second) {
        }
    }
}

