/*
 * Decompiled with CFR 0.152.
 */
package com.funnyboyroks.drawers.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class LocationSerializer
implements JsonSerializer<Location>,
JsonDeserializer<Location> {
    public Location deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        UUID world = UUID.fromString(obj.getAsJsonPrimitive("world").getAsString());
        double x = obj.getAsJsonPrimitive("x").getAsDouble();
        double y = obj.getAsJsonPrimitive("y").getAsDouble();
        double z = obj.getAsJsonPrimitive("z").getAsDouble();
        return new Location(Bukkit.getWorld((UUID)world), x, y, z);
    }

    public JsonElement serialize(Location src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject ret = new JsonObject();
        ret.add("world", (JsonElement)new JsonPrimitive(src.getWorld().getUID().toString()));
        ret.add("x", (JsonElement)new JsonPrimitive((Number)src.getX()));
        ret.add("y", (JsonElement)new JsonPrimitive((Number)src.getY()));
        ret.add("z", (JsonElement)new JsonPrimitive((Number)src.getZ()));
        return ret;
    }
}

