/*
 * Decompiled with CFR 0.152.
 */
package de.exlll.configlib;

import de.exlll.configlib.ConfigurationException;
import de.exlll.configlib.Reflect;
import de.exlll.configlib.Serializer;
import de.exlll.configlib.SerializerContext;
import de.exlll.configlib.Validator;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

final class Serializers {
    private Serializers() {
    }

    static <S extends Serializer<?, ?>> S newCustomSerializer(Class<S> serializerType, SerializerContext context) {
        return (S)(Reflect.hasConstructor(serializerType, SerializerContext.class) ? (Serializer)Reflect.callConstructor(serializerType, new Class[]{SerializerContext.class}, context) : (Serializer)Reflect.callNoParamConstructor(serializerType));
    }

    static final class PrimitiveDoubleArraySerializer
    implements Serializer<Object, List<Number>> {
        private static final NumberSerializer serializer = new NumberSerializer(Double.TYPE);

        PrimitiveDoubleArraySerializer() {
        }

        @Override
        public List<Number> serialize(Object element) {
            double[] array = (double[])element;
            return Arrays.stream(array).mapToObj(serializer::serialize).toList();
        }

        @Override
        public Object deserialize(List<Number> element) {
            double[] array = new double[element.size()];
            for (int i = 0; i < element.size(); ++i) {
                Number number = Validator.requireNonNullArrayElement(element.get(i), "double", i);
                array[i] = (Double)serializer.deserialize(number);
            }
            return array;
        }
    }

    static final class PrimitiveFloatArraySerializer
    implements Serializer<Object, List<Number>> {
        private static final NumberSerializer serializer = new NumberSerializer(Float.TYPE);

        PrimitiveFloatArraySerializer() {
        }

        @Override
        public List<Number> serialize(Object element) {
            float[] array = (float[])element;
            return IntStream.range(0, array.length).mapToObj(i -> serializer.serialize(Float.valueOf(array[i]))).toList();
        }

        @Override
        public Object deserialize(List<Number> element) {
            float[] array = new float[element.size()];
            for (int i = 0; i < element.size(); ++i) {
                Number number = Validator.requireNonNullArrayElement(element.get(i), "float", i);
                array[i] = ((Float)serializer.deserialize(number)).floatValue();
            }
            return array;
        }
    }

    static final class PrimitiveLongArraySerializer
    implements Serializer<Object, List<Number>> {
        private static final NumberSerializer serializer = new NumberSerializer(Long.TYPE);

        PrimitiveLongArraySerializer() {
        }

        @Override
        public List<Number> serialize(Object element) {
            long[] array = (long[])element;
            return Arrays.stream(array).mapToObj(serializer::serialize).toList();
        }

        @Override
        public Object deserialize(List<Number> element) {
            long[] array = new long[element.size()];
            for (int i = 0; i < element.size(); ++i) {
                Number number = Validator.requireNonNullArrayElement(element.get(i), "long", i);
                array[i] = (Long)serializer.deserialize(number);
            }
            return array;
        }
    }

    static final class PrimitiveIntegerArraySerializer
    implements Serializer<Object, List<Number>> {
        private static final NumberSerializer serializer = new NumberSerializer(Integer.TYPE);

        PrimitiveIntegerArraySerializer() {
        }

        @Override
        public List<Number> serialize(Object element) {
            int[] array = (int[])element;
            return Arrays.stream(array).mapToObj(serializer::serialize).toList();
        }

        @Override
        public Object deserialize(List<Number> element) {
            int[] array = new int[element.size()];
            for (int i = 0; i < element.size(); ++i) {
                Number number = Validator.requireNonNullArrayElement(element.get(i), "int", i);
                array[i] = (Integer)serializer.deserialize(number);
            }
            return array;
        }
    }

    static final class PrimitiveShortArraySerializer
    implements Serializer<Object, List<Number>> {
        private static final NumberSerializer serializer = new NumberSerializer(Short.TYPE);

        PrimitiveShortArraySerializer() {
        }

        @Override
        public List<Number> serialize(Object element) {
            short[] array = (short[])element;
            return IntStream.range(0, array.length).mapToObj(i -> serializer.serialize(array[i])).toList();
        }

        @Override
        public Object deserialize(List<Number> element) {
            short[] array = new short[element.size()];
            for (int i = 0; i < element.size(); ++i) {
                Number number = Validator.requireNonNullArrayElement(element.get(i), "short", i);
                array[i] = (Short)serializer.deserialize(number);
            }
            return array;
        }
    }

    static final class PrimitiveByteArraySerializer
    implements Serializer<Object, List<Number>> {
        private static final NumberSerializer serializer = new NumberSerializer(Byte.TYPE);

        PrimitiveByteArraySerializer() {
        }

        @Override
        public List<Number> serialize(Object element) {
            byte[] array = (byte[])element;
            return IntStream.range(0, array.length).mapToObj(i -> serializer.serialize(array[i])).toList();
        }

        @Override
        public Object deserialize(List<Number> element) {
            byte[] array = new byte[element.size()];
            for (int i = 0; i < element.size(); ++i) {
                Number number = Validator.requireNonNullArrayElement(element.get(i), "byte", i);
                array[i] = (Byte)serializer.deserialize(number);
            }
            return array;
        }
    }

    static final class PrimitiveCharacterArraySerializer
    implements Serializer<Object, List<String>> {
        private static final CharacterSerializer serializer = new CharacterSerializer();

        PrimitiveCharacterArraySerializer() {
        }

        @Override
        public List<String> serialize(Object element) {
            char[] array = (char[])element;
            return IntStream.range(0, array.length).mapToObj(i -> serializer.serialize(Character.valueOf(array[i]))).toList();
        }

        @Override
        public Object deserialize(List<String> element) {
            char[] array = new char[element.size()];
            for (int i = 0; i < element.size(); ++i) {
                String character = Validator.requireNonNullArrayElement(element.get(i), "char", i);
                array[i] = serializer.deserialize(character).charValue();
            }
            return array;
        }
    }

    static final class PrimitiveBooleanArraySerializer
    implements Serializer<Object, List<Boolean>> {
        PrimitiveBooleanArraySerializer() {
        }

        @Override
        public List<Boolean> serialize(Object element) {
            boolean[] array = (boolean[])element;
            return IntStream.range(0, array.length).mapToObj(i -> array[i]).toList();
        }

        @Override
        public Object deserialize(List<Boolean> element) {
            boolean[] array = new boolean[element.size()];
            for (int i = 0; i < element.size(); ++i) {
                array[i] = Validator.requireNonNullArrayElement(element.get(i), "boolean", i);
            }
            return array;
        }
    }

    static final class ArraySerializer<T1, T2>
    implements Serializer<T1[], List<T2>> {
        private final Class<?> componentType;
        private final Serializer<T1, T2> serializer;
        private final boolean outputNulls;
        private final boolean inputNulls;

        public ArraySerializer(Class<?> componentType, Serializer<T1, T2> serializer, boolean outputNulls, boolean inputNulls) {
            this.componentType = Validator.requireNonNull(componentType, "component type");
            this.serializer = Validator.requireNonNull(serializer, "element serializer");
            this.outputNulls = outputNulls;
            this.inputNulls = inputNulls;
        }

        @Override
        public List<T2> serialize(T1[] element) {
            Stream<Object> stream = this.outputNulls ? Arrays.stream(element).map(s -> s == null ? null : this.serializer.serialize(s)) : Arrays.stream(element).filter(Objects::nonNull).map(this.serializer::serialize);
            return stream.toList();
        }

        @Override
        public T1[] deserialize(List<T2> element) {
            Stream<Object> stream = this.inputNulls ? element.stream().map(t -> t == null ? null : this.serializer.deserialize(t)) : element.stream().filter(Objects::nonNull).map(this.serializer::deserialize);
            IntFunction<A[]> f = value -> Reflect.newArray(this.componentType, value);
            return stream.toArray(f);
        }

        public Class<?> getComponentType() {
            return this.componentType;
        }

        public Serializer<T1, T2> getElementSerializer() {
            return this.serializer;
        }
    }

    static final class MapSerializer<S1, T1, S2, T2>
    implements Serializer<Map<S1, S2>, Map<T1, T2>> {
        private final Serializer<S1, T1> keySerializer;
        private final Serializer<S2, T2> valSerializer;
        private final boolean outputNulls;
        private final boolean inputNulls;

        public MapSerializer(Serializer<S1, T1> keySerializer, Serializer<S2, T2> valSerializer, boolean outputNulls, boolean inputNulls) {
            this.keySerializer = Validator.requireNonNull(keySerializer, "key serializer");
            this.valSerializer = Validator.requireNonNull(valSerializer, "value serializer");
            this.outputNulls = outputNulls;
            this.inputNulls = inputNulls;
        }

        @Override
        public Map<T1, T2> serialize(Map<S1, S2> element) {
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            for (Map.Entry<S1, S2> entry : element.entrySet()) {
                if (!this.outputNulls && MapSerializer.isEntryNull(entry)) continue;
                S1 s1key = entry.getKey();
                S2 s2val = entry.getValue();
                Object t1key = s1key == null ? null : (Object)this.keySerializer.serialize(s1key);
                Object t2val = s2val == null ? null : (Object)this.valSerializer.serialize(s2val);
                result.put(t1key, t2val);
            }
            return result;
        }

        @Override
        public Map<S1, S2> deserialize(Map<T1, T2> element) {
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            for (Map.Entry<T1, T2> entry : element.entrySet()) {
                if (!this.inputNulls && MapSerializer.isEntryNull(entry)) continue;
                T1 t1key = entry.getKey();
                T2 t2val = entry.getValue();
                Object s1key = t1key == null ? null : (Object)this.keySerializer.deserialize(t1key);
                Object s2val = t2val == null ? null : (Object)this.valSerializer.deserialize(t2val);
                result.put(s1key, s2val);
            }
            return result;
        }

        private static boolean isEntryNull(Map.Entry<?, ?> entry) {
            return entry == null || entry.getKey() == null || entry.getValue() == null;
        }

        public Serializer<S1, T1> getKeySerializer() {
            return this.keySerializer;
        }

        public Serializer<S2, T2> getValueSerializer() {
            return this.valSerializer;
        }
    }

    static final class SetAsListSerializer<S, T>
    extends CollectionSerializer<S, T, Set<S>, List<T>> {
        public SetAsListSerializer(Serializer<S, T> serializer, boolean outputNulls, boolean inputNulls) {
            super(serializer, outputNulls, inputNulls, HashSet::new, ArrayList::new);
        }
    }

    static final class SetSerializer<S, T>
    extends CollectionSerializer<S, T, Set<S>, Set<T>> {
        public SetSerializer(Serializer<S, T> serializer, boolean outputNulls, boolean inputNulls) {
            super(serializer, outputNulls, inputNulls, HashSet::new, LinkedHashSet::new);
        }
    }

    static final class ListSerializer<S, T>
    extends CollectionSerializer<S, T, List<S>, List<T>> {
        public ListSerializer(Serializer<S, T> serializer, boolean outputNulls, boolean inputNulls) {
            super(serializer, outputNulls, inputNulls, ArrayList::new, ArrayList::new);
        }
    }

    static class CollectionSerializer<S, T, L extends Collection<S>, R extends Collection<T>>
    implements Serializer<L, R> {
        private final Serializer<S, T> serializer;
        private final boolean outputNulls;
        private final boolean inputNulls;
        private final Supplier<L> lSupplier;
        private final Supplier<R> rSupplier;

        public CollectionSerializer(Serializer<S, T> serializer, boolean outputNulls, boolean inputNulls, Supplier<L> lSupplier, Supplier<R> rSupplier) {
            this.serializer = Validator.requireNonNull(serializer, "element serializer");
            this.outputNulls = outputNulls;
            this.inputNulls = inputNulls;
            this.lSupplier = lSupplier;
            this.rSupplier = rSupplier;
        }

        @Override
        public final R serialize(L element) {
            Stream<Object> stream = this.outputNulls ? element.stream().map(s -> s == null ? null : this.serializer.serialize(s)) : element.stream().filter(Objects::nonNull).map(this.serializer::serialize);
            return (R)((Collection)stream.collect(Collectors.toCollection(this.rSupplier)));
        }

        @Override
        public final L deserialize(R element) {
            Stream<Object> stream = this.inputNulls ? element.stream().map(t -> t == null ? null : this.serializer.deserialize(t)) : element.stream().filter(Objects::nonNull).map(this.serializer::deserialize);
            return (L)((Collection)stream.collect(Collectors.toCollection(this.lSupplier)));
        }

        public final Serializer<S, T> getElementSerializer() {
            return this.serializer;
        }
    }

    static final class EnumSerializer
    implements Serializer<Enum<?>, String> {
        private final Class<? extends Enum<?>> cls;

        public EnumSerializer(Class<? extends Enum<?>> cls) {
            this.cls = Validator.requireNonNull(cls, "enum class");
        }

        @Override
        public String serialize(Enum<?> element) {
            return element.name();
        }

        @Override
        public Enum<?> deserialize(String element) {
            for (Enum<?> constant : this.cls.getEnumConstants()) {
                if (!constant.name().equals(element)) continue;
                return constant;
            }
            String msg = this.createExceptionMessage(element);
            throw new ConfigurationException(msg);
        }

        private String createExceptionMessage(String element) {
            String enums = Arrays.stream(this.cls.getEnumConstants()).map(Enum::name).collect(Collectors.joining(", ", "[", "]"));
            return "Enum class " + this.cls.getSimpleName() + " does not contain enum '" + element + "'. Valid values are: " + enums;
        }

        public Class<? extends Enum<?>> getEnumCls() {
            return this.cls;
        }
    }

    static final class UriSerializer
    implements Serializer<URI, String> {
        UriSerializer() {
        }

        @Override
        public String serialize(URI element) {
            return element.toString();
        }

        @Override
        public URI deserialize(String element) {
            return URI.create(element);
        }
    }

    static final class UrlSerializer
    implements Serializer<URL, String> {
        UrlSerializer() {
        }

        @Override
        public String serialize(URL element) {
            return element.toString();
        }

        @Override
        public URL deserialize(String element) {
            try {
                return new URL(element);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class PathSerializer
    implements Serializer<Path, String> {
        PathSerializer() {
        }

        @Override
        public String serialize(Path element) {
            return element.toString();
        }

        @Override
        public Path deserialize(String element) {
            return Path.of(element, new String[0]);
        }
    }

    static final class FileSerializer
    implements Serializer<File, String> {
        FileSerializer() {
        }

        @Override
        public String serialize(File element) {
            return element.toString();
        }

        @Override
        public File deserialize(String element) {
            return new File(element);
        }
    }

    static final class UuidSerializer
    implements Serializer<UUID, String> {
        UuidSerializer() {
        }

        @Override
        public String serialize(UUID element) {
            return element.toString();
        }

        @Override
        public UUID deserialize(String element) {
            return UUID.fromString(element);
        }
    }

    static final class InstantSerializer
    implements Serializer<Instant, String> {
        InstantSerializer() {
        }

        @Override
        public String serialize(Instant element) {
            return element.toString();
        }

        @Override
        public Instant deserialize(String element) {
            return Instant.parse(element);
        }
    }

    static final class LocalDateTimeSerializer
    implements Serializer<LocalDateTime, String> {
        LocalDateTimeSerializer() {
        }

        @Override
        public String serialize(LocalDateTime element) {
            return element.truncatedTo(ChronoUnit.SECONDS).toString();
        }

        @Override
        public LocalDateTime deserialize(String element) {
            return LocalDateTime.parse(element);
        }
    }

    static final class LocalDateSerializer
    implements Serializer<LocalDate, String> {
        LocalDateSerializer() {
        }

        @Override
        public String serialize(LocalDate element) {
            return element.toString();
        }

        @Override
        public LocalDate deserialize(String element) {
            return LocalDate.parse(element);
        }
    }

    static final class LocalTimeSerializer
    implements Serializer<LocalTime, String> {
        LocalTimeSerializer() {
        }

        @Override
        public String serialize(LocalTime element) {
            return element.truncatedTo(ChronoUnit.SECONDS).toString();
        }

        @Override
        public LocalTime deserialize(String element) {
            return LocalTime.parse(element);
        }
    }

    static final class BigDecimalSerializer
    implements Serializer<BigDecimal, String> {
        BigDecimalSerializer() {
        }

        @Override
        public String serialize(BigDecimal element) {
            return element.toString();
        }

        @Override
        public BigDecimal deserialize(String element) {
            return new BigDecimal(element);
        }
    }

    static final class BigIntegerSerializer
    implements Serializer<BigInteger, String> {
        BigIntegerSerializer() {
        }

        @Override
        public String serialize(BigInteger element) {
            return element.toString();
        }

        @Override
        public BigInteger deserialize(String element) {
            return new BigInteger(element);
        }
    }

    static final class CharacterSerializer
    implements Serializer<Character, String> {
        CharacterSerializer() {
        }

        @Override
        public String serialize(Character element) {
            return element.toString();
        }

        @Override
        public Character deserialize(String element) {
            int length = element.length();
            if (length == 0) {
                String msg = "An empty string cannot be converted to a character.";
                throw new ConfigurationException(msg);
            }
            if (length > 1) {
                String msg = "String '" + element + "' is too long to be converted to a character.";
                throw new ConfigurationException(msg);
            }
            return Character.valueOf(element.charAt(0));
        }
    }

    static final class StringSerializer
    implements Serializer<String, String> {
        StringSerializer() {
        }

        @Override
        public String serialize(String element) {
            return element;
        }

        @Override
        public String deserialize(String element) {
            return element;
        }
    }

    static final class NumberSerializer
    implements Serializer<Number, Number> {
        private final Class<? extends Number> cls;

        public NumberSerializer(Class<? extends Number> cls) {
            this.cls = Validator.requireNonNull(cls, "number class");
            Validator.requirePrimitiveOrWrapperNumberType(cls);
        }

        @Override
        public Number serialize(Number element) {
            if (Reflect.isIntegerType(this.cls)) {
                return element.longValue();
            }
            if (Reflect.isFloatingPointType(this.cls)) {
                return element.doubleValue();
            }
            String msg = "Invalid element '" + String.valueOf(element) + "' with type " + String.valueOf(element.getClass());
            throw new ConfigurationException(msg);
        }

        @Override
        public Number deserialize(Number element) {
            if (Reflect.isIntegerType(element.getClass())) {
                return this.deserializeFromIntegerType(element);
            }
            if (Reflect.isFloatingPointType(element.getClass())) {
                return this.deserializeFromFloatingPointType(element);
            }
            String clsName = element.getClass().getSimpleName();
            String msg = "Cannot deserialize element '" + String.valueOf(element) + "' of type " + clsName + ".\nThis serializer only supports primitive number types and their wrapper types.";
            throw new ConfigurationException(msg);
        }

        private Number deserializeFromFloatingPointType(Number element) {
            double value = element.doubleValue();
            if (this.cls == Float.TYPE || this.cls == Float.class) {
                if (Double.isNaN(value)) {
                    return Float.valueOf(Float.NaN);
                }
                if (value == Double.POSITIVE_INFINITY) {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                if (value == Double.NEGATIVE_INFINITY) {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
                if (value != 0.0) {
                    this.requireFloatingPointInRange(value);
                }
                return Float.valueOf(element.floatValue());
            }
            return value;
        }

        private Number deserializeFromIntegerType(Number element) {
            long value = element.longValue();
            if (this.cls == Byte.TYPE || this.cls == Byte.class) {
                this.requireIntegerInRange(value, -128L, 127L);
                return element.byteValue();
            }
            if (this.cls == Short.TYPE || this.cls == Short.class) {
                this.requireIntegerInRange(value, -32768L, 32767L);
                return element.shortValue();
            }
            if (this.cls == Integer.TYPE || this.cls == Integer.class) {
                this.requireIntegerInRange(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
                return element.intValue();
            }
            return value;
        }

        private void requireIntegerInRange(long value, long low, long high) {
            if (value < low || value > high) {
                String msg = this.baseExceptionMessage(value) + "It does not fit into the range of valid values [" + low + ", " + high + "].";
                throw new ConfigurationException(msg);
            }
        }

        private void requireFloatingPointInRange(double value) {
            String clsName = this.cls.getSimpleName();
            if (value > (double)-1.4E-45f && value < (double)1.4E-45f) {
                String msg = this.baseExceptionMessage(value) + "It is smaller than the smallest possible " + clsName + " value.";
                throw new ConfigurationException(msg);
            }
            if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
                String msg = this.baseExceptionMessage(value) + "It is larger than the largest possible " + clsName + " value.";
                throw new ConfigurationException(msg);
            }
        }

        private <T extends Number> String baseExceptionMessage(T value) {
            String clsName = this.cls.getSimpleName();
            return "Number " + String.valueOf(value) + " cannot be converted to type " + clsName + ". ";
        }

        public Class<? extends Number> getNumberClass() {
            return this.cls;
        }
    }

    static final class BooleanSerializer
    implements Serializer<Boolean, Boolean> {
        BooleanSerializer() {
        }

        @Override
        public Boolean serialize(Boolean element) {
            return element;
        }

        @Override
        public Boolean deserialize(Boolean element) {
            return element;
        }
    }
}

