/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.api;

import com.showcase.command.ShowcaseManager;
import com.showcase.data.ShareEntry;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ShowcaseManagerWrapper {
    ShowcaseManagerWrapper() {
    }

    @Nullable
    public ShareEntry getShareEntry(@NotNull String shareId) {
        return ShowcaseManager.getShareEntry(shareId);
    }

    @NotNull
    public Map<String, ShareEntry> getAllActiveShares() {
        return ShowcaseManager.getAllActiveShares();
    }

    @NotNull
    public List<ShareEntry> getPlayerShares(@NotNull String playerUuid) {
        return ShowcaseManager.getPlayerShares(playerUuid);
    }

    public boolean cancelShare(@NotNull String shareId) {
        return ShowcaseManager.cancelShare(shareId);
    }

    public boolean isOnCooldown(@NotNull class_3222 player, @NotNull ShowcaseManager.ShareType type) {
        return ShowcaseManager.isOnCooldown(player, type);
    }

    public long getRemainingCooldown(@NotNull class_3222 player, @NotNull ShowcaseManager.ShareType type) {
        return ShowcaseManager.getRemainingCooldown(player, type);
    }

    public boolean openSharedContent(@NotNull class_3222 viewer, @NotNull String shareId) {
        return ShowcaseManager.openSharedContent(viewer, shareId);
    }

    public boolean isValidShare(@NotNull String shareId) {
        ShareEntry entry = this.getShareEntry(shareId);
        if (entry == null) {
            return false;
        }
        long expiryTime = entry.getTimestamp() + (long)entry.getDuration() * 1000L;
        return System.currentTimeMillis() <= expiryTime;
    }

    public int getActiveShareCount() {
        return this.getAllActiveShares().size();
    }

    public int getPlayerShareCount(@NotNull String playerUuid) {
        return this.getPlayerShares(playerUuid).size();
    }
}

