/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.command;

import com.showcase.ShowcaseMod;
import com.showcase.api.ShowcaseAPI;
import com.showcase.config.ModConfigManager;
import com.showcase.data.ShareEntry;
import com.showcase.data.ShareRepository;
import com.showcase.gui.ContainerGui;
import com.showcase.gui.MerchantContext;
import com.showcase.gui.ReadonlyMerchantGui;
import com.showcase.placeholders.ShowcaseStatistics;
import com.showcase.utils.BookOpener;
import com.showcase.utils.CooldownManager;
import com.showcase.utils.HotbarSnapshotInventory;
import com.showcase.utils.ItemPreviewManager;
import com.showcase.utils.MapViewer;
import com.showcase.utils.PlayerUtils;
import com.showcase.utils.ReadOnlyInventory;
import com.showcase.utils.ScreenHandlerUtils;
import com.showcase.utils.StackUtils;
import com.showcase.utils.TextUtils;
import com.showcase.utils.compat.ServerPlayerCompat;
import com.showcase.utils.permissions.PermissionChecker;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public final class ShowcaseManager {
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "Showcase\u2011Cleanup");
        t.setDaemon(true);
        return t;
    });

    public static ScheduledExecutorService getScheduler() {
        return SCHEDULER;
    }

    private ShowcaseManager() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register(Map<String, ShareEntry> share) {
        if (share == null) {
            ShowcaseMod.LOGGER.info("No saved showcase shares to load");
            return;
        }
        ShareRepository.loadShares(share);
        ShowcaseMod.LOGGER.info("Loaded {} showcase shares from storage", (Object)share.size());
    }

    private static String nextId() {
        return UUID.randomUUID().toString().substring(0, 8);
    }

    public static String createStatsShare(class_3222 owner, class_1799 stack, Integer duration, Collection<class_3222> receivers) {
        String id = ShowcaseManager.nextId();
        ReadOnlyInventory inv = new ReadOnlyInventory(9, StackUtils.getDisplayName(stack), class_3917.field_18664);
        inv.method_5491(stack.method_7972());
        ShareRepository.store(id, new ShareEntry(owner.method_5667(), ShareType.STATS, inv, duration, receivers));
        ShowcaseStatistics.recordShareCreation(owner, ShareType.STATS, duration != null ? Duration.ofSeconds(duration.intValue()) : Duration.ofMinutes(5L));
        return id;
    }

    public static String createItemShare(class_3222 owner, class_1799 stack, Integer duration, Collection<class_3222> receivers) {
        String id = ShowcaseManager.nextId();
        ReadOnlyInventory inv = new ReadOnlyInventory(9, StackUtils.getDisplayName(stack), class_3917.field_18664);
        inv.method_5491(stack.method_7972());
        for (int i = 1; i < 9; ++i) {
            inv.method_5447(i, StackUtils.DIVIDER_ITEM);
        }
        ShareRepository.store(id, new ShareEntry(owner.method_5667(), ShareType.ITEM, inv, duration, receivers));
        ShowcaseStatistics.recordShareCreation(owner, ShareType.ITEM, duration != null ? Duration.ofSeconds(duration.intValue()) : Duration.ofMinutes(5L));
        return id;
    }

    public static String createInventoryShare(class_3222 owner, Integer duration, Collection<class_3222> receivers) {
        String id = ShowcaseManager.nextId();
        ReadOnlyInventory inv = StackUtils.snapshotFullInventory(owner);
        ShareRepository.store(id, new ShareEntry(owner.method_5667(), ShareType.INVENTORY, inv, duration, receivers));
        ShowcaseStatistics.recordShareCreation(owner, ShareType.INVENTORY, duration != null ? Duration.ofSeconds(duration.intValue()) : Duration.ofMinutes(5L));
        return id;
    }

    public static String createHotbarShare(class_3222 owner, Integer duration, Collection<class_3222> receivers) {
        String id = ShowcaseManager.nextId();
        HotbarSnapshotInventory inv = new HotbarSnapshotInventory(owner.method_31548());
        ShareRepository.store(id, new ShareEntry(owner.method_5667(), ShareType.HOTBAR, inv, duration, receivers));
        ShowcaseStatistics.recordShareCreation(owner, ShareType.HOTBAR, duration != null ? Duration.ofSeconds(duration.intValue()) : Duration.ofMinutes(5L));
        return id;
    }

    public static String createEnderChestShare(class_3222 owner, Integer duration, Collection<class_3222> receivers) {
        String id = ShowcaseManager.nextId();
        int size = owner.method_7274().method_5439();
        ReadOnlyInventory inv = new ReadOnlyInventory(size, TextUtils.ENDER_CHEST, ScreenHandlerUtils.handlerTypeForRows(size / 9));
        for (int i = 0; i < size; ++i) {
            inv.method_5447(i, owner.method_7274().method_5438(i).method_7972());
        }
        ShareRepository.store(id, new ShareEntry(owner.method_5667(), ShareType.ENDER_CHEST, inv, duration, receivers));
        ShowcaseStatistics.recordShareCreation(owner, ShareType.ENDER_CHEST, duration != null ? Duration.ofSeconds(duration.intValue()) : Duration.ofMinutes(5L));
        return id;
    }

    public static String createContainerShare(class_3222 owner, ReadOnlyInventory container, Integer duration, Collection<class_3222> receivers) {
        String id = ShowcaseManager.nextId();
        ShareRepository.store(id, new ShareEntry(owner.method_5667(), ShareType.CONTAINER, container, duration, receivers));
        ShowcaseStatistics.recordShareCreation(owner, ShareType.CONTAINER, duration != null ? Duration.ofSeconds(duration.intValue()) : Duration.ofMinutes(5L));
        return id;
    }

    public static String createMerchantShare(class_3222 owner, MerchantContext merchantContext, Integer duration, Collection<class_3222> receivers) {
        String id = ShowcaseManager.nextId();
        ShareRepository.store(id, new ShareEntry(owner.method_5667(), ShareType.MERCHANT, merchantContext, duration, receivers));
        ShowcaseStatistics.recordShareCreation(owner, ShareType.MERCHANT, duration != null ? Duration.ofSeconds(duration.intValue()) : Duration.ofMinutes(5L));
        return id;
    }

    public static boolean openSharedContent(class_3222 viewer, String id) {
        ShareEntry entry = ShareRepository.get(id);
        if (entry == null || ShowcaseManager.isExpired(entry)) {
            viewer.method_7353(TextUtils.warning((class_2561)class_2561.method_43471((String)"showcase.message.invalid_or_expired")), false);
            ShareRepository.remove(id);
            return false;
        }
        if (!(ShowcaseManager.canViewShare(entry, viewer) || viewer.method_5667().equals(entry.getOwnerUuid()) || PermissionChecker.isOp(viewer))) {
            viewer.method_64398(TextUtils.warning((class_2561)class_2561.method_43471((String)"showcase.message.manage.noPermission")));
            return false;
        }
        MinecraftServer server = ServerPlayerCompat.getServer(viewer);
        if (server == null) {
            return false;
        }
        class_3222 originalOwner = server.method_3760().method_14602(entry.getOwnerUuid());
        class_1269 result = ShowcaseAPI.fireShowcaseViewedEvent(viewer, entry, id, Objects.requireNonNullElse(originalOwner, viewer));
        if (result == class_1269.field_5814) {
            return false;
        }
        entry.incrementViewCount();
        ShowcaseStatistics.recordShareView(originalOwner != null ? originalOwner : viewer, viewer);
        try {
            ContainerGui gui = ShowcaseManager.factory(viewer, entry);
            if (gui != null) {
                gui.open();
            }
            return true;
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Failed to open showcase screen", (Throwable)e);
            return false;
        }
    }

    public static boolean isOnCooldown(class_3222 player, ShareType type) {
        boolean onCooldown = CooldownManager.isOnCooldown(player, type);
        if (onCooldown) {
            long remaining = CooldownManager.getRemainingCooldown(player, type);
            player.method_64398(TextUtils.warning((class_2561)class_2561.method_43469((String)"showcase.message.cooldown", (Object[])new Object[]{(int)Math.ceil(remaining)})));
        }
        return onCooldown;
    }

    public static boolean canViewShare(ShareEntry entry, class_3222 viewer) {
        if (entry.getReceiverUuids() == null || entry.getReceiverUuids().isEmpty()) {
            return true;
        }
        return entry.getReceiverUuids().contains(viewer.method_5667());
    }

    public static void setCooldown(class_3222 player, ShareType type) {
        CooldownManager.setCooldown(player, type);
    }

    public static boolean expireShareById(String id) {
        ShareEntry e = ShareRepository.get(id);
        if (e == null) {
            return false;
        }
        ShowcaseStatistics.recordShareExpiry(null, e.getType());
        e.invalidShare();
        return true;
    }

    public static int expireSharesByPlayer(UUID uuid) {
        int count = 0;
        for (Map.Entry<String, ShareEntry> e : ShareRepository.getAllShares().entrySet()) {
            if (!uuid.equals(e.getValue().getOwnerUuid())) continue;
            e.getValue().invalidShare();
            ++count;
        }
        return count;
    }

    public static void setShares(Map<String, ShareEntry> shares) {
        if (shares == null || shares.isEmpty()) {
            return;
        }
        ShareRepository.loadShares(shares);
    }

    public static ShareEntry getShareById(String id) {
        return ShareRepository.get(id);
    }

    public static Map<String, ShareEntry> getActiveShares() {
        return ShareRepository.getAllShares();
    }

    public static Map<String, ShareEntry> getAllActiveShares() {
        return ShowcaseManager.getActiveShares();
    }

    public static Map<String, ShareEntry> getUnmodifiableActiveShares() {
        return ShareRepository.getUnmodifiableShares();
    }

    public static void clearAll() {
        ShareRepository.clear();
        CooldownManager.clearAllCooldowns();
        if (!SCHEDULER.isShutdown()) {
            SCHEDULER.shutdownNow();
        }
    }

    public static ShareEntry getShareEntry(String id) {
        return ShareRepository.get(id);
    }

    public static class_1799 getItemStackWithID(String shareId) {
        ShareEntry shareEntry = ShowcaseManager.getShareEntry(shareId);
        if (shareEntry == null || shareEntry.getType() != ShareType.ITEM) {
            return null;
        }
        return shareEntry.getInventory().method_5438(0).method_7972();
    }

    public static List<ShareEntry> getPlayerShares(String playerUuid) {
        return ShareRepository.getAllShares().values().stream().filter(entry -> entry.getOwnerUuid().toString().equals(playerUuid)).collect(Collectors.toList());
    }

    public static boolean cancelShare(String shareId) {
        return ShowcaseManager.expireShareById(shareId);
    }

    public static long getRemainingCooldown(class_3222 player, ShareType type) {
        return CooldownManager.getRemainingCooldown(player, type);
    }

    public static List<String> getShareIdCompletions() {
        return new ArrayList<String>(ShowcaseManager.getUnmodifiableActiveShares().keySet());
    }

    private static ContainerGui factory(class_3222 viewer, ShareEntry entry) {
        ReadOnlyInventory inv = entry.getInventory();
        MinecraftServer server = ServerPlayerCompat.getServer(viewer);
        if (server == null) {
            return null;
        }
        class_5250 ownerName = PlayerUtils.getSafeDisplayName(server, entry.getOwnerUuid());
        return switch (entry.getType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                class_1799 itemStack = inv.method_5438(0);
                if (StackUtils.isBook(itemStack).booleanValue()) {
                    new BookOpener(viewer, itemStack).open();
                    yield null;
                }
                if (StackUtils.isMap(itemStack).booleanValue() && ModConfigManager.getConfig().mapViewDuration != -1) {
                    MapViewer.viewMap(viewer, itemStack);
                    yield null;
                }
                ReadOnlyInventory unpackInv = StackUtils.unpackFromItemStack(itemStack);
                if (unpackInv != null) {
                    class_3917<?> type = unpackInv.getType();
                    class_5250 name = class_2561.method_43469((String)"showcase.screen.item_title", (Object[])new Object[]{ownerName, unpackInv.getName()});
                    yield new ContainerGui(type, viewer, (class_2561)name, (class_1263)unpackInv);
                }
                class_5250 customTitle = class_2561.method_43469((String)"showcase.screen.item_title", (Object[])new Object[]{ownerName, StackUtils.getDisplayName(itemStack)});
                ItemPreviewManager.showItemPreviewWithTitle(viewer, itemStack, (class_2561)customTitle);
                yield null;
            }
            case 6 -> {
                class_1799 itemStack = inv.method_5438(0);
                if (StackUtils.isBook(itemStack).booleanValue()) {
                    new BookOpener(viewer, itemStack).open();
                    yield null;
                }
                yield null;
            }
            case 5 -> {
                new ReadonlyMerchantGui(viewer, entry.getMerchantContext()).open();
                yield null;
            }
            case 1 -> new ContainerGui(inv.getType(), viewer, (class_2561)class_2561.method_43469((String)"showcase.screen.inventory_title", (Object[])new Object[]{ownerName}), (class_1263)inv);
            case 2 -> new ContainerGui(inv.getType(), viewer, (class_2561)class_2561.method_43469((String)"showcase.screen.hotbar_title", (Object[])new Object[]{ownerName, TextUtils.HOTBAR}), (class_1263)inv);
            case 3 -> new ContainerGui(inv.getType(), viewer, (class_2561)class_2561.method_43469((String)"showcase.screen.ender_chest_title", (Object[])new Object[]{ownerName, TextUtils.ENDER_CHEST}), (class_1263)inv);
            case 4 -> new ContainerGui(inv.getType(), viewer, (class_2561)class_2561.method_43469((String)"showcase.screen.container_title", (Object[])new Object[]{ownerName, inv.getName()}), (class_1263)inv);
        };
    }

    private static boolean isExpired(ShareEntry e) {
        if (e == null) {
            return true;
        }
        return e.getIsInvalid() || Instant.now().toEpochMilli() - e.getTimestamp() > (long)e.getDuration() * 1000L;
    }

    private static void purgeExpired() {
        long now = Instant.now().toEpochMilli();
        Set<Map.Entry> expiredEntries = ShareRepository.getAllShares().entrySet().stream().filter(e -> now - ((ShareEntry)e.getValue()).getTimestamp() > (long)((ShareEntry)e.getValue()).getDuration() * 1000L || ((ShareEntry)e.getValue()).getIsInvalid()).collect(Collectors.toSet());
        expiredEntries.forEach(entry -> ShowcaseStatistics.recordShareExpiry(null, ((ShareEntry)entry.getValue()).getType()));
        expiredEntries.forEach(entry -> ShareRepository.remove((String)entry.getKey()));
    }

    static {
        long intervalSeconds = 60L;
        SCHEDULER.scheduleAtFixedRate(ShowcaseManager::purgeExpired, intervalSeconds, intervalSeconds, TimeUnit.SECONDS);
        long cooldownCleanupInterval = 300L;
        SCHEDULER.scheduleAtFixedRate(() -> {
            try {
                CooldownManager.cleanupExpiredCooldowns();
            }
            catch (Exception e) {
                ShowcaseMod.LOGGER.error("Error during cooldown cleanup", (Throwable)e);
            }
        }, cooldownCleanupInterval, cooldownCleanupInterval, TimeUnit.SECONDS);
    }

    public static enum ShareType {
        ITEM,
        INVENTORY,
        HOTBAR,
        ENDER_CHEST,
        CONTAINER,
        MERCHANT,
        STATS;

    }
}

