/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.data;

import com.showcase.ShowcaseMod;
import com.showcase.data.JsonCodecDataStorage;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class GlobalDataManager {
    private static final Map<class_2960, JsonCodecDataStorage<?>> STORAGES = new ConcurrentHashMap();
    private static final Map<class_2960, Object> CACHE = new ConcurrentHashMap<class_2960, Object>();

    private GlobalDataManager() {
    }

    public static <T> void register(class_2960 id, JsonCodecDataStorage<T> storage) {
        STORAGES.put(id, storage);
        ShowcaseMod.LOGGER.debug("Registered storage for id: {}", (Object)id);
    }

    @Nullable
    public static <T> T getData(MinecraftServer server, class_2960 id) {
        Object cached = CACHE.get(id);
        if (cached != null) {
            ShowcaseMod.LOGGER.debug("Loaded data from cache for id: {}", (Object)id);
            return (T)cached;
        }
        JsonCodecDataStorage<?> storage = STORAGES.get(id);
        if (storage == null) {
            ShowcaseMod.LOGGER.warn("No storage found for id: {}", (Object)id);
            return null;
        }
        Object data = null;
        try {
            data = storage.load(server);
            if (data != null) {
                CACHE.put(id, data);
                ShowcaseMod.LOGGER.debug("Loaded data from storage for id: {}", (Object)id);
            } else {
                ShowcaseMod.LOGGER.debug("No data found on disk for id: {}", (Object)id);
            }
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Error loading data for id: {}", (Object)id, (Object)e);
        }
        return (T)data;
    }

    public static <T> void setData(MinecraftServer server, class_2960 id, T data) {
        JsonCodecDataStorage<?> storage = STORAGES.get(id);
        if (storage == null) {
            ShowcaseMod.LOGGER.warn("No storage registered for id: {}, cannot save data", (Object)id);
            return;
        }
        try {
            boolean saved = storage.save(server, data);
            if (saved) {
                if (data != null) {
                    CACHE.put(id, data);
                    ShowcaseMod.LOGGER.debug("Saved and cached data for id: {}", (Object)id);
                } else {
                    CACHE.remove(id);
                    ShowcaseMod.LOGGER.debug("Removed cached data for id: {}", (Object)id);
                }
            } else {
                ShowcaseMod.LOGGER.warn("Failed to save data for id: {}", (Object)id);
            }
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Exception while saving data for id: {}", (Object)id, (Object)e);
        }
    }

    public static void saveAll(MinecraftServer server) {
        Objects.requireNonNull(server, "Server must not be null");
        ShowcaseMod.LOGGER.info("Saving all global cached data, total entries: {}", (Object)CACHE.size());
        for (Map.Entry<class_2960, Object> entry : CACHE.entrySet()) {
            try {
                GlobalDataManager.setData(server, entry.getKey(), entry.getValue());
                ShowcaseMod.LOGGER.debug("Saved global data for id: {}", (Object)entry.getKey());
            }
            catch (Exception e) {
                ShowcaseMod.LOGGER.error("Failed to save global data for id: {}", (Object)entry.getKey(), (Object)e);
            }
        }
        ShowcaseMod.LOGGER.info("Completed saving all global data");
    }
}

