/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.showcase.command.ShowcaseManager;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public record PlayerStatisticsData(int totalShares, long totalViews, Map<ShowcaseManager.ShareType, Integer> sharesByType, Map<String, Integer> sharesPerDay, List<Long> shareDurationSeconds, ShowcaseManager.ShareType mostSharedType, Long lastShareTime) {
    public static final Codec<PlayerStatisticsData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("totalShares").forGetter(PlayerStatisticsData::totalShares), (App)Codec.LONG.fieldOf("totalViews").forGetter(PlayerStatisticsData::totalViews), (App)Codec.unboundedMap((Codec)Codec.STRING.xmap(ShowcaseManager.ShareType::valueOf, Enum::name), (Codec)Codec.INT).fieldOf("sharesByType").forGetter(PlayerStatisticsData::sharesByType), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).fieldOf("sharesPerDay").forGetter(PlayerStatisticsData::sharesPerDay), (App)Codec.LONG.listOf().fieldOf("shareDurationSeconds").forGetter(PlayerStatisticsData::shareDurationSeconds), (App)Codec.STRING.xmap(name -> name.equals("null") ? null : ShowcaseManager.ShareType.valueOf(name), type -> type == null ? "null" : type.name()).optionalFieldOf("mostSharedType", null).forGetter(PlayerStatisticsData::mostSharedType), (App)Codec.LONG.optionalFieldOf("lastShareTime", null).forGetter(PlayerStatisticsData::lastShareTime)).apply((Applicative)instance, PlayerStatisticsData::new));

    public static PlayerStatisticsData empty() {
        return new PlayerStatisticsData(0, 0L, new HashMap<ShowcaseManager.ShareType, Integer>(), new HashMap<String, Integer>(), List.of(), null, null);
    }

    public List<Duration> getShareDurations() {
        return this.shareDurationSeconds.stream().map(Duration::ofSeconds).toList();
    }

    public Instant getLastShareTimeInstant() {
        return this.lastShareTime != null ? Instant.ofEpochMilli(this.lastShareTime) : null;
    }
}

