/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.gui;

import com.showcase.utils.BookOpener;
import com.showcase.utils.MapViewer;
import com.showcase.utils.StackUtils;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import net.minecraft.class_1263;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class ContainerGui
extends SimpleGui {
    private ContainerGui parentGui = null;
    private boolean isOpeningNestedContainer = false;

    public ContainerGui(class_3917<?> containerType, class_3222 player, class_2561 title, class_2371<class_1799> items) {
        super(containerType, player, false);
        int expectedSlots = GuiHelpers.getHeight(containerType) * GuiHelpers.getWidth(containerType);
        if (items.size() > expectedSlots) {
            throw new IllegalArgumentException("Items size exceeds container capacity");
        }
        this.setTitle(title);
        this.setupItems(items);
    }

    public ContainerGui(class_3917<?> containerType, class_3222 player, class_2561 title, class_1263 inventory) {
        super(containerType, player, false);
        this.setTitle(title);
        this.setupItemsFromInventory(inventory);
    }

    public void setParentGui(ContainerGui parent) {
        this.parentGui = parent;
    }

    private void prepareToOpenNextGUI() {
        this.isOpeningNestedContainer = true;
        GuiHelpers.ignoreNextGuiClosing((class_3222)this.player);
    }

    private void openNestedContainer(class_1799 clickedItem, class_2371<class_1799> contents, class_3917<?> containerType) {
        if (contents.isEmpty()) {
            return;
        }
        this.prepareToOpenNextGUI();
        ContainerGui nestedGui = new ContainerGui(containerType, this.player, clickedItem.method_7964(), contents);
        nestedGui.setParentGui(this);
        this.close(false);
        nestedGui.open();
        this.isOpeningNestedContainer = false;
    }

    private class_2371<class_1799> getCurrentItems() {
        class_2371 items = class_2371.method_10213((int)this.getVirtualSize(), (Object)class_1799.field_8037);
        for (int i = 0; i < this.getVirtualSize(); ++i) {
            GuiElementInterface element = this.getSlot(i);
            if (element == null || element.getItemStack().method_7960()) continue;
            items.set(i, (Object)element.getItemStack().method_7972());
        }
        return items;
    }

    public void onClose() {
        if (this.isOpeningNestedContainer) {
            this.isOpeningNestedContainer = false;
            return;
        }
        super.onClose();
        this.openPreviousGui();
    }

    private void openPreviousGui() {
        if (this.parentGui != null) {
            this.parentGui.open();
        }
    }

    private static class_2371<class_1799> getShulkerBoxContents(class_1799 shulkerBox) {
        class_9288 container = (class_9288)shulkerBox.method_57824(class_9334.field_49622);
        if (container != null) {
            class_2371 items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
            container.method_57492(items);
            return items;
        }
        return class_2371.method_10211();
    }

    private static class_2371<class_1799> getBundleContents(class_1799 bundle) {
        class_2371 items = class_2371.method_10211();
        class_9276 bundleContents = (class_9276)bundle.method_57824(class_9334.field_49650);
        if (bundleContents != null) {
            bundleContents.method_57421().forEach(arg_0 -> items.add(arg_0));
        }
        return items;
    }

    private static class_3917<?> getShulkerBoxContainerType() {
        return class_3917.field_17341;
    }

    private static class_3917<?> getBundleContainerType() {
        return class_3917.field_18664;
    }

    private void setupItems(class_2371<class_1799> items) {
        int maxSlots = Math.min(items.size(), this.getVirtualSize());
        for (int i = 0; i < maxSlots; ++i) {
            class_1799 stack = (class_1799)items.get(i);
            if (stack.method_7960()) continue;
            this.setSlot(i, this.createReadOnlyElement(stack));
        }
    }

    private void setupItemsFromInventory(class_1263 inventory) {
        int maxSlots = Math.min(inventory.method_5439(), this.getVirtualSize());
        for (int i = 0; i < maxSlots; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            this.setSlot(i, this.createReadOnlyElement(stack));
        }
    }

    private GuiElementInterface createReadOnlyElement(class_1799 stack) {
        return new GuiElement(stack.method_7972(), this::handleItemClick);
    }

    private void handleItemClick(int i, ClickType clickType, class_1713 slotActionType, SlotGuiInterface slotGuiInterface) {
    }

    private void onShulkerBoxClick(class_1799 stack, ContainerGui gui) {
        gui.openNestedContainer(stack, ContainerGui.getShulkerBoxContents(stack), ContainerGui.getShulkerBoxContainerType());
    }

    private void onBundleClick(class_1799 stack, ContainerGui gui) {
        gui.openNestedContainer(stack, ContainerGui.getBundleContents(stack), ContainerGui.getBundleContainerType());
    }

    private void onBookClick(class_1799 stack, class_3222 player) {
        this.close();
        BookOpener bookOpener = new BookOpener(player, stack);
        bookOpener.open();
    }

    private void onMapClick(class_1799 stack, class_3222 player) {
        this.close();
        MapViewer.viewMap(player, stack);
    }

    public void refreshItems(class_2371<class_1799> items) {
        for (int i = 0; i < this.getVirtualSize(); ++i) {
            this.clearSlot(i);
        }
        this.setupItems(items);
    }

    public void refreshItemsFromInventory(class_1263 inventory) {
        for (int i = 0; i < this.getVirtualSize(); ++i) {
            this.clearSlot(i);
        }
        this.setupItemsFromInventory(inventory);
    }

    public boolean onClick(int index, ClickType type, class_1713 action, GuiElementInterface element) {
        if (type == ClickType.DROP || type == ClickType.CTRL_DROP) {
            this.close();
            return true;
        }
        class_1799 clickedStack = element.getItemStack();
        if (clickedStack == null) {
            return false;
        }
        if (StackUtils.isShulkerBox(clickedStack)) {
            this.onShulkerBoxClick(clickedStack, this);
        }
        if (StackUtils.isBundle(clickedStack)) {
            this.onBundleClick(clickedStack, this);
        }
        if (StackUtils.isMap(clickedStack).booleanValue()) {
            this.onMapClick(clickedStack, this.player);
        }
        if (StackUtils.isBook(clickedStack).booleanValue()) {
            this.onBookClick(clickedStack, this.player);
        }
        return false;
    }
}

