/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.listener;

import com.showcase.ShowcaseMod;
import com.showcase.config.ModConfigManager;
import com.showcase.listener.ChatKeywordHandler;
import com.showcase.utils.compat.ServerPlayerCompat;
import com.showcase.utils.permissions.PermissionChecker;
import com.showcase.utils.permissions.Permissions;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.parsers.NodeParser;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;

public class ChatMessageListener {
    private static ChatKeywordHandler keywordHandler;
    private static final NodeParser CHAT_PARSER;

    public static void registerChatHandler() {
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register(ChatMessageListener::messageHandler);
    }

    public static void loadConfig() {
        keywordHandler = new ChatKeywordHandler(ModConfigManager.getConfig());
    }

    private static boolean messageHandler(class_7471 message, class_3222 sender, class_2556.class_7602 params) {
        if (keywordHandler == null) {
            ShowcaseMod.LOGGER.warn("ChatKeywordHandler not initialized; skipping placeholder processing.");
            return true;
        }
        if (!PermissionChecker.hasPermission(sender, Permissions.Chat.PLACEHOLDER, 0)) {
            return true;
        }
        if (message.method_46291().getString().length() >= 100 && !PermissionChecker.isOp(sender)) {
            return true;
        }
        String originalText = message.method_46291().getString();
        String processedText = keywordHandler.processMessage(originalText, sender);
        ShowcaseMod.LOGGER.debug("Original: '{}', Processed: '{}'", (Object)originalText, (Object)processedText);
        if (ChatMessageListener.containsPlaceholders(processedText)) {
            class_2561 parsedMessage;
            try {
                parsedMessage = CHAT_PARSER.parseText(processedText, PlaceholderContext.of((class_3222)sender).asParserContext());
            }
            catch (Exception e) {
                ShowcaseMod.LOGGER.error("Failed to parse chat message: {}", (Object)processedText, (Object)e);
                return true;
            }
            if (ServerPlayerCompat.getServer(sender) == null) {
                return true;
            }
            ServerPlayerCompat.getServer(sender).method_3760().method_43514((class_2561)class_2561.method_43469((String)"chat.type.text", (Object[])new Object[]{sender.method_5476(), parsedMessage}), false);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean containsPlaceholders(String text) {
        if (text == null) return false;
        if (text.isEmpty()) return false;
        if (!ChatKeywordHandler.getSupportedPlaceholders().stream().anyMatch(text::contains)) return false;
        return true;
    }

    static {
        CHAT_PARSER = NodeParser.builder().globalPlaceholders().requireSafe().build();
    }
}

