/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.listener;

import com.showcase.gui.MerchantContext;
import com.showcase.utils.ContainerTitleResolver;
import com.showcase.utils.ReadOnlyInventory;
import com.showcase.utils.StackUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1728;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;

public class ContainerOpenWatcher {
    private static final Map<UUID, WatchContainer> watchContainerPending = new ConcurrentHashMap<UUID, WatchContainer>();
    private static final Map<UUID, WatchMerchant> watchMerchantPending = new ConcurrentHashMap<UUID, WatchMerchant>();

    public static void awaitMerchantGuiOpened(class_3222 player, int duration, MerchantGuiCallback onSuccess, Runnable onTimeout) {
        if (player == null) {
            return;
        }
        watchMerchantPending.put(player.method_5667(), new WatchMerchant(onSuccess, onTimeout, duration));
    }

    public static void awaitContainerOpened(class_3222 player, int duration, ContainerCallback onSuccess, Runnable onTimeout) {
        if (player == null) {
            return;
        }
        watchContainerPending.put(player.method_5667(), new WatchContainer(onSuccess, onTimeout, duration));
    }

    public static void onMerchantGuiOpened(class_3222 player, class_3908 factory) {
        if (player == null) {
            return;
        }
        UUID playerId = player.method_5667();
        WatchMerchant entry = watchMerchantPending.remove(playerId);
        class_1703 handler = player.field_7512;
        if (handler == null || entry == null) {
            return;
        }
        MerchantContext merchantContext = ContainerOpenWatcher.getMerchantContext(handler, ContainerTitleResolver.resolveContainerTitle(player, handler, factory));
        if (merchantContext == null) {
            if (entry.onTimeout != null) {
                entry.onTimeout.run();
            }
            return;
        }
        entry.onSuccess.onOpened(player, merchantContext);
    }

    private static MerchantContext getMerchantContext(class_1703 handler, class_2561 name) {
        if (!(handler instanceof class_1728)) {
            return null;
        }
        class_1728 merchantHandler = (class_1728)handler;
        try {
            class_1916 offers = merchantHandler.method_17438();
            int level = merchantHandler.method_19254();
            int experience = merchantHandler.method_19258();
            return new MerchantContext(offers, level, experience, merchantHandler.method_19259(), name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void onContainerOpened(class_3222 player, class_3908 factory) {
        ReadOnlyInventory tempInv;
        class_3917 type;
        if (player == null) {
            return;
        }
        UUID playerId = player.method_5667();
        WatchContainer entry = watchContainerPending.remove(playerId);
        if (entry == null) {
            return;
        }
        class_1703 handler = player.field_7512;
        if (handler == null) {
            if (entry.onTimeout != null) {
                entry.onTimeout.run();
            }
            return;
        }
        class_2561 name = ContainerTitleResolver.resolveContainerTitle(player, handler, factory);
        class_3917 class_39172 = type = handler.method_17358() == class_3917.field_46790 ? class_3917.field_17333 : handler.method_17358();
        if (handler instanceof class_1707) {
            class_1707 containerHandler = (class_1707)handler;
            tempInv = ContainerOpenWatcher.createGenericContainerInventory(containerHandler, name, type);
        } else {
            tempInv = ContainerOpenWatcher.createSlotBasedInventory(handler, player, name, type);
        }
        if (tempInv.method_5442()) {
            if (entry.onTimeout != null) {
                entry.onTimeout.run();
            }
            return;
        }
        entry.onSuccess.onOpened(player, tempInv);
    }

    private static ReadOnlyInventory createGenericContainerInventory(class_1707 containerHandler, class_2561 name, class_3917<?> type) {
        class_1263 containerInventory = containerHandler.method_7629();
        ReadOnlyInventory tempInv = new ReadOnlyInventory(containerInventory.method_5439(), name, type);
        for (int i = 0; i < containerInventory.method_5439(); ++i) {
            class_1799 stack = containerInventory.method_5438(i);
            tempInv.method_5447(i, StackUtils.isValid(stack) ? stack.method_7972() : class_1799.field_8037);
        }
        return tempInv;
    }

    private static ReadOnlyInventory createSlotBasedInventory(class_1703 handler, class_3222 player, class_2561 name, class_3917<?> type) {
        List<class_1735> nonPlayerSlots = handler.field_7761.stream().filter(slot -> slot.field_7871 != player.method_31548()).toList();
        ReadOnlyInventory tempInv = new ReadOnlyInventory(nonPlayerSlots.size(), name, type);
        for (int i = 0; i < nonPlayerSlots.size(); ++i) {
            class_1799 stack = nonPlayerSlots.get(i).method_7677();
            tempInv.method_5447(i, StackUtils.isValid(stack) ? stack.method_7972() : class_1799.field_8037);
        }
        return tempInv;
    }

    @Deprecated
    public static class_2561 resolveContainerTitle(class_3908 factory) {
        return ContainerTitleResolver.resolveContainerTitle(factory);
    }

    public static void registerTickEvent() {
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            Iterator<Map.Entry<UUID, WatchContainer>> containerIter = watchContainerPending.entrySet().iterator();
            while (containerIter.hasNext()) {
                Map.Entry<UUID, WatchContainer> entry = containerIter.next();
                WatchContainer wc = entry.getValue();
                --wc.ticksLeft;
                if (wc.ticksLeft > 0) continue;
                containerIter.remove();
                if (wc.onTimeout == null) continue;
                wc.onTimeout.run();
            }
            Iterator<Map.Entry<UUID, WatchMerchant>> merchantIter = watchMerchantPending.entrySet().iterator();
            while (merchantIter.hasNext()) {
                Map.Entry<UUID, WatchMerchant> entry = merchantIter.next();
                WatchMerchant wm = entry.getValue();
                --wm.ticksLeft;
                if (wm.ticksLeft > 0) continue;
                merchantIter.remove();
                if (wm.onTimeout == null) continue;
                wm.onTimeout.run();
            }
        });
    }

    public static void cleanup() {
        watchContainerPending.clear();
        watchMerchantPending.clear();
    }

    public static int getPendingContainerCount() {
        return watchContainerPending.size();
    }

    public static int getPendingMerchantCount() {
        return watchMerchantPending.size();
    }

    private static class WatchMerchant {
        MerchantGuiCallback onSuccess;
        Runnable onTimeout;
        int ticksLeft;

        WatchMerchant(MerchantGuiCallback onSuccess, Runnable onTimeout, int ticksLeft) {
            this.onSuccess = onSuccess;
            this.onTimeout = onTimeout;
            this.ticksLeft = ticksLeft * 20;
        }
    }

    public static interface MerchantGuiCallback {
        public void onOpened(class_3222 var1, MerchantContext var2);
    }

    private static class WatchContainer {
        ContainerCallback onSuccess;
        Runnable onTimeout;
        int ticksLeft;

        WatchContainer(ContainerCallback onSuccess, Runnable onTimeout, int ticksLeft) {
            this.onSuccess = onSuccess;
            this.onTimeout = onTimeout;
            this.ticksLeft = ticksLeft * 20;
        }
    }

    public static interface ContainerCallback {
        public void onOpened(class_3222 var1, ReadOnlyInventory var2);
    }
}

