/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils;

import com.showcase.config.ModConfigManager;
import com.showcase.gui.ContainerGui;
import com.showcase.gui.ItemViewerContext;
import com.showcase.gui.ItemViewerGui;
import com.showcase.utils.StackUtils;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public final class ItemPreviewManager {
    private static final String ITEM_PREVIEW_MARK = "isShowcaseItemPreview";

    public static void showItemPreview(class_3222 player, class_1799 item) {
        if (player == null || item == null || item.method_7960()) {
            return;
        }
        int itemViewDuration = ModConfigManager.getConfig().itemViewDuration;
        if (itemViewDuration == -1) {
            ItemPreviewManager.showTraditionalContainerView(player, item);
        } else {
            int durationTicks = itemViewDuration == 0 ? 0 : itemViewDuration * 20;
            ItemPreviewManager.showHotbarPreview(player, item, durationTicks);
        }
    }

    private static void showTraditionalContainerView(class_3222 player, class_1799 item) {
        class_2371 items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        items.set(0, (Object)item.method_7972());
        ContainerGui gui = new ContainerGui(class_3917.field_18664, player, StackUtils.getDisplayName(item), (class_2371<class_1799>)items);
        gui.open();
    }

    private static void showHotbarPreview(class_3222 player, class_1799 item, int durationTicks) {
        if (player.method_7325()) {
            return;
        }
        class_1799 displayItem = item.method_7972();
        class_9279 customData = (class_9279)displayItem.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = customData.method_57461();
        nbt.method_10556(ITEM_PREVIEW_MARK, true);
        displayItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        int durationSeconds = durationTicks / 20;
        ItemViewerContext context = new ItemViewerContext(player, displayItem, durationSeconds);
        ItemViewerGui gui = new ItemViewerGui(context, 0);
    }

    public static void showItemPreviewWithTitle(class_3222 player, class_1799 item, class_2561 customTitle) {
        if (player == null || item == null || item.method_7960()) {
            return;
        }
        int itemViewDuration = ModConfigManager.getConfig().itemViewDuration;
        if (itemViewDuration == -1 || ModConfigManager.getConfig().mapViewDuration != -1 && StackUtils.isMap(item).booleanValue()) {
            class_2371 items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
            items.set(0, (Object)item.method_7972());
            ContainerGui gui = new ContainerGui(class_3917.field_18664, player, customTitle, (class_2371<class_1799>)items);
            gui.open();
        } else {
            ItemPreviewManager.showHotbarPreview(player, item, itemViewDuration * 20);
        }
    }

    @Deprecated
    public static void showItemPreview(class_3222 player, class_1799 item, class_2561 customTitle) {
        ItemPreviewManager.showItemPreviewWithTitle(player, item, customTitle);
    }
}

