/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.showcase.ShowcaseMod;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class PlayerUtils {
    public static Set<UUID> getReceiverUuids(Collection<class_3222> receivers) {
        if (receivers == null) {
            return null;
        }
        return receivers.stream().map(class_1297::method_5667).collect(Collectors.toSet());
    }

    public static class_5250 getSafeDisplayName(class_3222 player) {
        if (player == null) {
            return class_2561.method_43471((String)"argument.entity.notfound.player");
        }
        class_5250 displayName = class_2561.method_43469((String)"chat.type.text", (Object[])new Object[]{player.method_5476(), ""});
        return (class_5250)Objects.requireNonNullElseGet(displayName, () -> ((class_3222)player).method_5477());
    }

    public static class_5250 getSafeDisplayName(MinecraftServer server, UUID uuid) {
        if (server == null) {
            return class_2561.method_43471((String)"argument.entity.notfound.player");
        }
        class_3222 player = server.method_3760().method_14602(uuid);
        if (player != null) {
            return PlayerUtils.getSafeDisplayName(player);
        }
        Optional<String> playerName = PlayerUtils.getPlayerNameFromUuid(server, uuid);
        return playerName.map(s -> class_2561.method_43469((String)"chat.type.text", (Object[])new Object[]{s, ""})).orElseGet(() -> class_2561.method_43471((String)"argument.entity.notfound.player"));
    }

    public static Optional<String> getPlayerNameFromCache(MinecraftServer server, UUID uuid) {
        try {
            Optional profile;
            class_3312 userCache = server.method_3793();
            if (userCache != null && (profile = userCache.method_14512(uuid)).isPresent()) {
                return Optional.of(((GameProfile)profile.get()).getName());
            }
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Error getting player name from cache: {}", (Object)e.getMessage());
        }
        return Optional.empty();
    }

    public static Optional<String> getPlayerNameFromUserCacheFile(MinecraftServer server, UUID uuid) {
        try {
            Path worldPath = server.method_27050(class_5218.field_24188);
            Path userCachePath = worldPath.resolve("usercache.json");
            if (Files.exists(userCachePath, new LinkOption[0])) {
                JsonObject[] entries;
                String content = Files.readString(userCachePath);
                for (JsonObject entry : entries = (JsonObject[])JsonParser.parseString((String)content).getAsJsonArray().asList().stream().map(JsonElement::getAsJsonObject).toArray(JsonObject[]::new)) {
                    if (!entry.has("uuid") || !entry.has("name")) continue;
                    String entryUuid = entry.get("uuid").getAsString();
                    if (!uuid.toString().equals(entryUuid)) continue;
                    return Optional.of(entry.get("name").getAsString());
                }
            }
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Error reading usercache.json: {}", (Object)e.getMessage());
        }
        return Optional.empty();
    }

    public static Optional<String> getPlayerNameFromUuid(MinecraftServer server, UUID uuid) {
        Optional<String> name = PlayerUtils.getPlayerNameFromCache(server, uuid);
        if (name.isPresent()) {
            return name;
        }
        name = PlayerUtils.getPlayerNameFromUserCacheFile(server, uuid);
        if (name.isEmpty()) {
            String shortUuid = uuid.toString().substring(0, 8);
            return ("Player-" + shortUuid).describeConstable();
        }
        return name;
    }
}

