/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils.countdown;

import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CountdownBossBar {
    private class_3213 bossBar;
    private class_3222 player;
    private final int totalTicks;
    private int ticksLeft;
    private final class_2561 baseTitle;
    private boolean isRunning;
    private boolean isFinished;
    private boolean isPaused;
    private CountdownCallback callback;
    private int lastSecond = -1;

    public CountdownBossBar(class_3222 player, class_2561 title, int seconds) {
        this.player = player;
        this.ticksLeft = this.totalTicks = seconds * 20;
        this.baseTitle = title;
        this.isRunning = false;
        this.isFinished = false;
        this.isPaused = false;
        this.bossBar = new class_3213(title, class_1259.class_1260.field_5785, class_1259.class_1261.field_5795);
        this.bossBar.method_14088(player);
        this.updateBossBar();
    }

    public CountdownBossBar setCallback(CountdownCallback callback) {
        this.callback = callback;
        return this;
    }

    public void start() {
        if (this.isFinished) {
            return;
        }
        this.isRunning = true;
        this.isPaused = false;
    }

    public void stop() {
        if (!this.isRunning || this.isFinished) {
            return;
        }
        this.isRunning = false;
        this.isFinished = true;
        this.cleanup();
        if (this.callback != null) {
            this.callback.onStop();
        }
    }

    public void pause() {
        if (this.isRunning && !this.isFinished) {
            this.isPaused = true;
        }
    }

    public void resume() {
        if (this.isRunning && !this.isFinished) {
            this.isPaused = false;
        }
    }

    public void setTimeLeft(int seconds) {
        if (seconds < 0) {
            seconds = 0;
        }
        this.ticksLeft = seconds * 20;
        this.updateBossBar();
    }

    public void addTime(int seconds) {
        this.ticksLeft += seconds * 20;
        if (this.ticksLeft < 0) {
            this.ticksLeft = 0;
        }
        this.updateBossBar();
    }

    public void tick() {
        if (!this.isRunning || this.isFinished || this.isPaused) {
            return;
        }
        if (this.player == null || this.player.method_31481()) {
            this.stop();
            return;
        }
        if (this.ticksLeft <= 0) {
            this.complete();
            return;
        }
        --this.ticksLeft;
        this.updateBossBar();
        int currentSecond = this.getSecondsLeft();
        if (currentSecond != this.lastSecond && this.callback != null) {
            this.callback.onSecondTick(currentSecond);
            this.lastSecond = currentSecond;
        }
    }

    private void complete() {
        if (this.isFinished) {
            return;
        }
        this.isFinished = true;
        this.isRunning = false;
        this.cleanup();
        if (this.callback != null) {
            this.callback.onComplete();
        }
    }

    private void updateBossBar() {
        if (this.bossBar == null || this.player == null) {
            return;
        }
        int secondsLeft = this.getSecondsLeft();
        float progress = Math.max(0.0f, Math.min(1.0f, (float)this.ticksLeft / (float)this.totalTicks));
        this.bossBar.method_5408(progress);
        class_5250 newTitle = this.baseTitle.method_27661().method_10852((class_2561)class_2561.method_43470((String)(" (" + secondsLeft + "s)")));
        if (!this.bossBar.method_5414().equals((Object)newTitle)) {
            this.bossBar.method_5413((class_2561)newTitle);
        }
        if (progress <= 0.3f) {
            this.bossBar.method_5416(class_1259.class_1260.field_5784);
        } else if (progress <= 0.5f) {
            this.bossBar.method_5416(class_1259.class_1260.field_5782);
        } else {
            this.bossBar.method_5416(class_1259.class_1260.field_5785);
        }
        if (progress <= 0.05f) {
            this.bossBar.method_5409(class_1259.class_1261.field_5790);
        } else {
            this.bossBar.method_5409(class_1259.class_1261.field_5795);
        }
    }

    private void cleanup() {
        if (this.bossBar != null && this.player != null) {
            this.bossBar.method_14089(this.player);
        }
    }

    public void destroy() {
        this.stop();
        if (this.bossBar != null) {
            this.bossBar.method_14094();
        }
        this.bossBar = null;
        this.player = null;
        this.callback = null;
    }

    public int getSecondsLeft() {
        return Math.max(0, (this.ticksLeft + 19) / 20);
    }

    public int getTicksLeft() {
        return Math.max(0, this.ticksLeft);
    }

    public int getTotalSeconds() {
        return this.totalTicks / 20;
    }

    public int getTotalTicks() {
        return this.totalTicks;
    }

    public boolean isRunning() {
        return this.isRunning && !this.isFinished;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public class_3222 getPlayer() {
        return this.player;
    }

    public float getProgress() {
        return (float)this.ticksLeft / (float)this.totalTicks;
    }

    public static interface CountdownCallback {
        public void onComplete();

        public void onStop();

        public void onSecondTick(int var1);
    }
}

