/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils.inventory;

import com.showcase.utils.ScreenHandlerUtils;
import com.showcase.utils.inventory.ReadOnlyInventory;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3917;

public final class InventoryUtils {
    public static final int PLAYER_INVENTORY_SIZE = 36;
    public static final int HOTBAR_SIZE = 9;
    public static final int ENDERCHEST_SIZE = 27;
    public static final int HOTBAR_START = 0;
    public static final int HOTBAR_END = 8;
    public static final int MAIN_INVENTORY_START = 9;
    public static final int MAIN_INVENTORY_END = 35;

    private InventoryUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static ReadOnlyInventory snapshotPlayerInventory(class_1661 player) {
        int i;
        int rows = 4;
        ReadOnlyInventory snapshot = new ReadOnlyInventory(36, (class_2561)class_2561.method_43471((String)"container.inventory"), ScreenHandlerUtils.handlerTypeForRows(rows));
        for (i = 0; i <= 8; ++i) {
            snapshot.method_5447(i, player.method_5438(i).method_7972());
        }
        for (i = 9; i <= 35; ++i) {
            snapshot.method_5447(i, player.method_5438(i).method_7972());
        }
        return snapshot;
    }

    public static ReadOnlyInventory snapshotHotbar(class_1661 player) {
        ReadOnlyInventory snapshot = new ReadOnlyInventory(9, (class_2561)class_2561.method_43471((String)"showcase.inventory.hotbar"), class_3917.field_18664);
        for (int i = 0; i < 9; ++i) {
            snapshot.method_5447(i, player.method_5438(i).method_7972());
        }
        return snapshot;
    }

    public static ReadOnlyInventory snapshotInventory(class_1263 source, class_2561 displayName) {
        int size = source.method_5439();
        int rows = (size + 8) / 9;
        ReadOnlyInventory snapshot = new ReadOnlyInventory(size, displayName, ScreenHandlerUtils.handlerTypeForRows(rows));
        for (int i = 0; i < size; ++i) {
            snapshot.method_5447(i, source.method_5438(i).method_7972());
        }
        return snapshot;
    }

    public static ReadOnlyInventory snapshotInventory(class_1263 source, class_2561 displayName, class_3917<?> screenHandler) {
        ReadOnlyInventory snapshot = new ReadOnlyInventory(source.method_5439(), displayName, screenHandler);
        for (int i = 0; i < source.method_5439(); ++i) {
            snapshot.method_5447(i, source.method_5438(i).method_7972());
        }
        return snapshot;
    }

    public static int countNonEmptyStacks(class_1263 inventory) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (inventory.method_5438(i).method_7960()) continue;
            ++count;
        }
        return count;
    }

    public static boolean isEmpty(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (inventory.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public static class_1799 getFirstNonEmptyStack(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    public static void copySlots(class_1263 source, class_1263 target, int sourceStart, int targetStart, int count) {
        for (int i = 0; i < count; ++i) {
            int sourceSlot = sourceStart + i;
            int targetSlot = targetStart + i;
            if (sourceSlot >= source.method_5439() || targetSlot >= target.method_5439()) continue;
            target.method_5447(targetSlot, source.method_5438(sourceSlot).method_7972());
        }
    }
}

