/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils.stats;

import com.showcase.utils.minecraft.BlockCategoryCache;
import com.showcase.utils.minecraft.BlockCategoryRegistry;
import com.showcase.utils.stats.StatAPI;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3469;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class StatCollector
implements StatAPI {
    @Override
    public Map<String, Integer> getPlayerStats(class_3222 player) {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        class_3469 statHandler = this.getStatHandler(player);
        this.addCustomStats(stats, statHandler);
        this.addBlockCategoryStats(stats, statHandler);
        this.addEntityStats(stats, statHandler);
        return stats;
    }

    private void addCustomStats(Map<String, Integer> stats, class_3469 statHandler) {
        stats.put("stat.minecraft.play_time", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15417)));
        stats.put("stat.minecraft.time_since_death", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15400)));
        stats.put("stat.minecraft.time_since_rest", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15429)));
        stats.put("stat.minecraft.sneak_time", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15422)));
        stats.put("stat.minecraft.walk_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15377)));
        stats.put("stat.minecraft.crouch_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15376)));
        stats.put("stat.minecraft.sprint_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15364)));
        stats.put("stat.minecraft.swim_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15423)));
        stats.put("stat.minecraft.fall_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15386)));
        stats.put("stat.minecraft.climb_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15413)));
        stats.put("stat.minecraft.fly_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15426)));
        stats.put("stat.minecraft.walk_under_water_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15401)));
        stats.put("stat.minecraft.minecart_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15409)));
        stats.put("stat.minecraft.boat_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15415)));
        stats.put("stat.minecraft.pig_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15387)));
        stats.put("stat.minecraft.horse_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15396)));
        stats.put("stat.minecraft.aviate_one_cm", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15374)));
        stats.put("stat.minecraft.jump", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15428)));
        stats.put("stat.minecraft.drop", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15406)));
        stats.put("stat.minecraft.damage_dealt", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15399)));
        stats.put("stat.minecraft.damage_dealt_absorbed", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15408)));
        stats.put("stat.minecraft.damage_dealt_resisted", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15397)));
        stats.put("stat.minecraft.damage_taken", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15388)));
        stats.put("stat.minecraft.damage_blocked_by_shield", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15380)));
        stats.put("stat.minecraft.damage_absorbed", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15365)));
        stats.put("stat.minecraft.damage_resisted", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15425)));
        stats.put("stat.minecraft.deaths", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15421)));
        stats.put("stat.minecraft.mob_kills", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15414)));
        stats.put("stat.minecraft.animals_bred", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15410)));
        stats.put("stat.minecraft.player_kills", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15404)));
        stats.put("stat.minecraft.fish_caught", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15391)));
        stats.put("stat.minecraft.talked_to_villager", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15384)));
        stats.put("stat.minecraft.traded_with_villager", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15378)));
        stats.put("stat.minecraft.eat_cake_slice", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15369)));
        stats.put("stat.minecraft.fill_cauldron", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15430)));
        stats.put("stat.minecraft.use_cauldron", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15373)));
        stats.put("stat.minecraft.clean_armor", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15382)));
        stats.put("stat.minecraft.clean_banner", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15390)));
        stats.put("stat.minecraft.clean_shulker_box", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15398)));
        stats.put("stat.minecraft.interact_with_brewingstand", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15407)));
        stats.put("stat.minecraft.interact_with_beacon", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15416)));
        stats.put("stat.minecraft.inspect_dropper", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15367)));
        stats.put("stat.minecraft.inspect_hopper", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15366)));
        stats.put("stat.minecraft.inspect_dispenser", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15371)));
        stats.put("stat.minecraft.play_noteblock", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15385)));
        stats.put("stat.minecraft.tune_noteblock", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15393)));
        stats.put("stat.minecraft.pot_flower", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15412)));
        stats.put("stat.minecraft.trigger_trapped_chest", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15402)));
        stats.put("stat.minecraft.open_enderchest", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15424)));
        stats.put("stat.minecraft.enchant_item", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15420)));
        stats.put("stat.minecraft.play_record", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15375)));
        stats.put("stat.minecraft.interact_with_furnace", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15379)));
        stats.put("stat.minecraft.interact_with_crafting_table", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15368)));
        stats.put("stat.minecraft.open_chest", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15395)));
        stats.put("stat.minecraft.sleep_in_bed", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15381)));
        stats.put("stat.minecraft.open_shulker_box", statHandler.method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15418)));
    }

    private void addBlockCategoryStats(Map<String, Integer> stats, class_3469 statHandler) {
        int totalBlocksPlaced = 0;
        int totalBlocksBroken = 0;
        HashMap<CallSite, Integer> placedByCategory = new HashMap<CallSite, Integer>();
        HashMap<CallSite, Integer> brokenByCategory = new HashMap<CallSite, Integer>();
        for (class_2248 block : class_7923.field_41175) {
            int broken;
            String categoryKey;
            class_5321<class_1761> category;
            int placed;
            class_1792 blockItem = block.method_8389();
            if (blockItem != null && (placed = statHandler.method_15024(class_3468.field_15372, (Object)blockItem)) > 0) {
                totalBlocksPlaced += placed;
                category = BlockCategoryCache.getCachedCategory(blockItem);
                categoryKey = BlockCategoryRegistry.getTranslationKey(category);
                placedByCategory.merge((CallSite)((Object)(categoryKey + ".placed")), placed, Integer::sum);
            }
            if ((broken = statHandler.method_15024(class_3468.field_15427, (Object)block)) <= 0) continue;
            totalBlocksBroken += broken;
            if (blockItem == null) continue;
            category = BlockCategoryCache.getCachedCategory(blockItem);
            categoryKey = BlockCategoryRegistry.getTranslationKey(category);
            brokenByCategory.merge((CallSite)((Object)(categoryKey + ".broken")), broken, Integer::sum);
        }
        if (totalBlocksPlaced > 0) {
            stats.put("showcase.stats.blocks.total_placed", totalBlocksPlaced);
        }
        if (totalBlocksBroken > 0) {
            stats.put("showcase.stats.blocks.total_broken", totalBlocksBroken);
        }
        stats.putAll(placedByCategory);
        stats.putAll(brokenByCategory);
    }

    private void addEntityStats(Map<String, Integer> stats, class_3469 statHandler) {
        class_7923.field_41177.forEach(entityType -> {
            String entityId = class_7923.field_41177.method_10221(entityType).toString();
            this.addStatIfNonZero(stats, "stat.minecraft.kill_entity." + entityId, statHandler.method_15024(class_3468.field_15403, entityType));
            this.addStatIfNonZero(stats, "stat.minecraft.entity_killed_by." + entityId, statHandler.method_15024(class_3468.field_15411, entityType));
        });
    }

    private void addStatIfNonZero(Map<String, Integer> stats, String key, int value) {
        if (value > 0) {
            stats.put(key, value);
        }
    }
}

