/*
 * Decompiled with CFR 0.152.
 */
package com.showcase;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import com.showcase.command.PlaceholderTestCommand;
import com.showcase.command.ShowcaseCommand;
import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfigManager;
import com.showcase.data.GlobalDataManager;
import com.showcase.data.JsonCodecDataStorage;
import com.showcase.data.ShareEntry;
import com.showcase.listener.ChatMessageListener;
import com.showcase.listener.ContainerOpenWatcher;
import com.showcase.placeholders.Placeholders;
import com.showcase.placeholders.ShowcaseStatistics;
import com.showcase.utils.DevUtils;
import com.showcase.utils.MapViewer;
import com.showcase.utils.ModMetadataHolder;
import com.showcase.utils.ResourcePackChecker;
import com.showcase.utils.countdown.CountdownBossBarManager;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowcaseMod
implements ModInitializer {
    public static final String MOD_ID = "showcase";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"showcase");
    public static final class_2960 PLAYER_SHARE_STORAGE_ID = class_2960.method_60655((String)"showcase", (String)"showcase_storage");
    public static final Codec<Map<String, ShareEntry>> PLAYER_SHARE_ENTRY_CODEC = Codec.unboundedMap((Codec)Codec.STRING, ShareEntry.SHARE_ENTRY_CODEC);
    public static final JsonCodecDataStorage<Map<String, ShareEntry>> PLAYER_SHARE_STORAGE = new JsonCodecDataStorage<Map<String, ShareEntry>>("player_share_entry", PLAYER_SHARE_ENTRY_CODEC);

    public void onInitialize() {
        ModConfigManager.loadConfig();
        ModMetadataHolder.load();
        ChatMessageListener.loadConfig();
        GlobalDataManager.register(PLAYER_SHARE_STORAGE_ID, PLAYER_SHARE_STORAGE);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            ShowcaseCommand.register((CommandDispatcher<class_2168>)dispatcher);
            DevUtils.ifDevelopment(() -> PlaceholderTestCommand.register((CommandDispatcher<class_2168>)dispatcher));
        });
        ShowcaseStatistics.initialize();
        Placeholders.registerPlaceholders();
        ChatMessageListener.registerChatHandler();
        CountdownBossBarManager.registerTickEvent();
        ContainerOpenWatcher.registerTickEvent();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            try {
                Map data = (Map)GlobalDataManager.getData(server, PLAYER_SHARE_STORAGE_ID);
                if (data != null) {
                    ShowcaseManager.register(data);
                }
                ShowcaseStatistics.setServer(server);
                ResourcePackChecker.checkResourcePackConfiguration(server);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load showcase data", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            MapViewer.restoreAll(server);
            ContainerOpenWatcher.cleanup();
            CountdownBossBarManager.cleanup();
            try {
                GlobalDataManager.setData(server, PLAYER_SHARE_STORAGE_ID, ShowcaseManager.getActiveShares());
                ShowcaseStatistics.saveStatistics();
                GlobalDataManager.saveAll(server);
            }
            catch (Exception e) {
                LOGGER.error("Failed to save showcase data", (Throwable)e);
            }
            ShowcaseManager.clearAll();
            ResourcePackChecker.reset();
            LOGGER.info("Cleaned up shared items on server shutdown");
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ResourcePackChecker.sendResourcePackWarningToPlayer(handler.method_32311()));
        LOGGER.info("Showcase Mod initialized successfully!");
    }
}

