/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.showcase.command.ShareCommandUtils;
import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfigManager;
import com.showcase.data.ShareEntry;
import com.showcase.listener.ContainerOpenWatcher;
import com.showcase.utils.StackUtils;
import com.showcase.utils.TextUtils;
import com.showcase.utils.TimeUtils;
import com.showcase.utils.countdown.CountdownBossBar;
import com.showcase.utils.countdown.CountdownBossBarManager;
import com.showcase.utils.permissions.PermissionChecker;
import com.showcase.utils.stats.StatUtils;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ShareCommandExecutor {
    private static final SuggestionProvider<class_2168> TIME_SUGGESTIONS = (context, builder) -> {
        String input = builder.getRemaining().toLowerCase();
        int min = ModConfigManager.getShareLinkMinExpiry();
        int max = ModConfigManager.getShareLinkDefaultExpiry();
        boolean isOp = false;
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            isOp = PermissionChecker.isOp(player);
        }
        catch (Exception player) {
            // empty catch block
        }
        if (input.isEmpty()) {
            int suggestedMin = min;
            int suggestedMid = (min + max) / 2;
            int suggestedMax = max;
            String minFormat = TimeUtils.formatDurationShort(suggestedMin);
            String midFormat = TimeUtils.formatDurationShort(suggestedMid);
            String maxFormat = TimeUtils.formatDurationShort(suggestedMax);
            builder.suggest(minFormat, (Message)class_2561.method_43469((String)"showcase.command.duration.suggestion.minimum", (Object[])new Object[]{TimeUtils.formatSeconds(suggestedMin)}));
            builder.suggest(midFormat, (Message)class_2561.method_43469((String)"showcase.command.duration.suggestion.recommended", (Object[])new Object[]{TimeUtils.formatSeconds(suggestedMid)}));
            builder.suggest(maxFormat, (Message)class_2561.method_43469((String)"showcase.command.duration.suggestion.maximum", (Object[])new Object[]{TimeUtils.formatSeconds(suggestedMax)}));
            if (isOp) {
                builder.suggest("1h", (Message)class_2561.method_43471((String)"showcase.command.duration.suggestion.op_only"));
            }
        } else {
            try {
                int seconds = TimeUtils.parseTimeToSeconds(input);
                if (!(isOp || seconds >= min && seconds <= max)) {
                    builder.suggest(input, (Message)class_2561.method_43469((String)"showcase.command.duration.error.out_of_range", (Object[])new Object[]{TimeUtils.formatSeconds(min), TimeUtils.formatSeconds(max)}));
                } else {
                    String timeDisplay = TimeUtils.formatSeconds(seconds);
                    class_5250 status = isOp ? class_2561.method_43469((String)"showcase.command.duration.valid.op", (Object[])new Object[]{timeDisplay}) : class_2561.method_43469((String)"showcase.command.duration.valid", (Object[])new Object[]{timeDisplay});
                    builder.suggest(input, (Message)status);
                }
            }
            catch (IllegalArgumentException e) {
                if (input.matches("\\d+")) {
                    try {
                        int numValue = Integer.parseInt(input);
                        builder.suggest(input + "s", (Message)class_2561.method_43471((String)"showcase.command.duration.hint.add_seconds"));
                        builder.suggest(input + "m", (Message)class_2561.method_43471((String)"showcase.command.duration.hint.add_minutes"));
                        if (isOp || numValue <= max / 60) {
                            builder.suggest(input + "h", (Message)class_2561.method_43471((String)"showcase.command.duration.hint.add_hours"));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        builder.suggest(input, (Message)class_2561.method_43471((String)"showcase.command.duration.error.invalid_format"));
                    }
                }
                builder.suggest(input, (Message)class_2561.method_43471((String)"showcase.command.duration.error.invalid_format"));
            }
        }
        return builder.buildFuture();
    };

    public static RequiredArgumentBuilder<class_2168, String> shareDurationArgument() {
        return class_2170.method_9244((String)"duration", (ArgumentType)StringArgumentType.word()).suggests(TIME_SUGGESTIONS);
    }

    public static LiteralArgumentBuilder<class_2168> createItemShareCommand(boolean withSource) {
        return ShareCommandExecutor.createShareCommand("item", withSource, ShareCommandExecutor::shareItem);
    }

    public static LiteralArgumentBuilder<class_2168> createStatsShareCommand(boolean withSource) {
        return ShareCommandExecutor.createShareCommand("stats", withSource, ShareCommandExecutor::shareStats);
    }

    public static LiteralArgumentBuilder<class_2168> createInventoryShareCommand(boolean withSource) {
        return ShareCommandExecutor.createShareCommand("inventory", withSource, ShareCommandExecutor::shareInventory);
    }

    public static LiteralArgumentBuilder<class_2168> createHotbarShareCommand(boolean withSource) {
        return ShareCommandExecutor.createShareCommand("hotbar", withSource, ShareCommandExecutor::shareHotbar);
    }

    public static LiteralArgumentBuilder<class_2168> createEnderChestShareCommand(boolean withSource) {
        return ShareCommandExecutor.createShareCommand("ender_chest", withSource, ShareCommandExecutor::shareEnderChest);
    }

    public static LiteralArgumentBuilder<class_2168> createContainerShareCommand() {
        return ShareCommandExecutor.createSimpleShareCommand("container", ShareCommandExecutor::shareContainer);
    }

    public static LiteralArgumentBuilder<class_2168> shareMerchantShareCommand() {
        return ShareCommandExecutor.createSimpleShareCommand("merchant", ShareCommandExecutor::shareMerchant);
    }

    public static LiteralArgumentBuilder<class_2168> createCancelCommand() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"cancel").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            class_3222 player = ShareCommandUtils.getSenderPlayer((CommandContext<class_2168>)ctx);
            if (player != null) {
                ShowcaseManager.getUnmodifiableActiveShares().entrySet().stream().filter(e -> ((ShareEntry)e.getValue()).getOwnerUuid().equals(player.method_5667())).map(Map.Entry::getKey).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            class_3222 player = ShareCommandUtils.getSenderPlayer((CommandContext<class_2168>)ctx);
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            return ShareCommandExecutor.cancelShare(player, id);
        }));
    }

    private static LiteralArgumentBuilder<class_2168> createShareCommand(String commandName, boolean withSource, ShareExecutor executor) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)commandName).executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, null, null, null, null));
        if (withSource) {
            command.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"source", (ArgumentType)class_2186.method_9305()).executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, ShareCommandUtils.getSourcePlayer((CommandContext<class_2168>)ctx), null, null, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"receivers", (ArgumentType)class_2186.method_9308()).executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, ShareCommandUtils.getSourcePlayer((CommandContext<class_2168>)ctx), null, ShareCommandUtils.getReceivers((CommandContext<class_2168>)ctx), null))).then(((RequiredArgumentBuilder)ShareCommandExecutor.shareDurationArgument().executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, ShareCommandUtils.getSourcePlayer((CommandContext<class_2168>)ctx), null, ShareCommandUtils.getReceivers((CommandContext<class_2168>)ctx), ShareCommandExecutor.getValidatedDuration((CommandContext<class_2168>)ctx)))).then(class_2170.method_9244((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, ShareCommandUtils.getSourcePlayer((CommandContext<class_2168>)ctx), ShareCommandUtils.getDescription((CommandContext<class_2168>)ctx), ShareCommandUtils.getReceivers((CommandContext<class_2168>)ctx), ShareCommandExecutor.getValidatedDuration((CommandContext<class_2168>)ctx)))))));
        } else {
            command.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"receivers", (ArgumentType)class_2186.method_9308()).executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, null, null, ShareCommandUtils.getReceivers((CommandContext<class_2168>)ctx), null))).then(((RequiredArgumentBuilder)ShareCommandExecutor.shareDurationArgument().executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, null, null, ShareCommandUtils.getReceivers((CommandContext<class_2168>)ctx), ShareCommandExecutor.getValidatedDuration((CommandContext<class_2168>)ctx)))).then(class_2170.method_9244((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, null, ShareCommandUtils.getDescription((CommandContext<class_2168>)ctx), ShareCommandUtils.getReceivers((CommandContext<class_2168>)ctx), ShareCommandExecutor.getValidatedDuration((CommandContext<class_2168>)ctx))))));
        }
        return command;
    }

    private static LiteralArgumentBuilder<class_2168> createSimpleShareCommand(String commandName, SimpleShareExecutor executor) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)commandName).executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, null, null, null));
        command.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"receivers", (ArgumentType)class_2186.method_9308()).executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, null, ShareCommandUtils.getReceivers((CommandContext<class_2168>)ctx), null))).then(((RequiredArgumentBuilder)ShareCommandExecutor.shareDurationArgument().executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, null, ShareCommandUtils.getReceivers((CommandContext<class_2168>)ctx), ShareCommandExecutor.getValidatedDuration((CommandContext<class_2168>)ctx)))).then(class_2170.method_9244((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> executor.execute((CommandContext<class_2168>)ctx, ShareCommandUtils.getDescription((CommandContext<class_2168>)ctx), ShareCommandUtils.getReceivers((CommandContext<class_2168>)ctx), ShareCommandExecutor.getValidatedDuration((CommandContext<class_2168>)ctx))))));
        return command;
    }

    private static int executeShare(CommandContext<class_2168> ctx, ShowcaseManager.ShareType type, @Nullable Function<class_3222, class_1799> stackSupplier, @Nullable String emptyMessageKey, QuadFunction<class_3222, @Nullable class_1799, Integer, Collection<class_3222>, String> shareCreator, class_2561 defaultDisplayName, String description, Collection<class_3222> receivers, Integer duration) {
        try {
            class_3222 sender = ShareCommandUtils.getSenderPlayer(ctx);
            if (sender == null) {
                return 0;
            }
            if (ShowcaseManager.isOnCooldown(sender, type)) {
                return 0;
            }
            if (receivers != null && !ShareCommandUtils.canSpecifyReceivers(sender, type)) {
                sender.method_64398(TextUtils.error((class_2561)class_2561.method_43471((String)"showcase.command.no_permission.receivers")));
                return 0;
            }
            if (duration != null && !ShareCommandUtils.canSpecifyDuration(sender, type)) {
                sender.method_64398(TextUtils.error((class_2561)class_2561.method_43471((String)"showcase.command.no_permission.duration")));
                return 0;
            }
            if (description != null && !description.isEmpty() && !ShareCommandUtils.canSpecifyDescription(sender, type)) {
                sender.method_64398(TextUtils.error((class_2561)class_2561.method_43471((String)"showcase.command.no_permission.description")));
                return 0;
            }
            class_3222 source = ShareCommandUtils.getSourceOrSender(ctx);
            class_1799 stack = class_1799.field_8037;
            if (stackSupplier != null && (stack = stackSupplier.apply(source).method_7972()).method_7960()) {
                sender.method_64398(TextUtils.error((class_2561)class_2561.method_43471((String)emptyMessageKey)));
                return 0;
            }
            String shareId = shareCreator.apply(source, (class_1799)(stackSupplier != null ? stack : null), duration, receivers);
            class_2561 displayName = stackSupplier != null ? StackUtils.getDisplayName(stack) : defaultDisplayName;
            ShareCommandUtils.sendShareMessage(sender, source, receivers, description, type, displayName, duration, shareId);
            ShowcaseManager.setCooldown(sender, type);
            return 1;
        }
        catch (RuntimeException e) {
            ShareCommandUtils.handleError(ctx, e);
            return -1;
        }
    }

    public static int shareItem(CommandContext<class_2168> ctx, class_3222 sourcePlayer, String description, Collection<class_3222> receivers, Integer duration) {
        return ShareCommandExecutor.executeShare(ctx, ShowcaseManager.ShareType.ITEM, player -> player.method_6118(class_1304.field_6173), "showcase.message.no_item", ShowcaseManager::createItemShare, (class_2561)class_2561.method_43473(), description, receivers, duration);
    }

    public static int shareStats(CommandContext<class_2168> ctx, class_3222 sourcePlayer, String description, Collection<class_3222> receivers, Integer duration) {
        return ShareCommandExecutor.executeShare(ctx, ShowcaseManager.ShareType.STATS, StatUtils::createStatsBook, "showcase.message.no_stats", ShowcaseManager::createStatsShare, (class_2561)class_2561.method_43473(), description, receivers, duration);
    }

    public static int shareInventory(CommandContext<class_2168> ctx, class_3222 sourcePlayer, String description, Collection<class_3222> receivers, Integer duration) {
        return ShareCommandExecutor.executeShare(ctx, ShowcaseManager.ShareType.INVENTORY, null, null, (player, unused, dur, recv) -> ShowcaseManager.createInventoryShare(player, dur, recv), TextUtils.INVENTORY, description, receivers, duration);
    }

    public static int shareHotbar(CommandContext<class_2168> ctx, class_3222 sourcePlayer, String description, Collection<class_3222> receivers, Integer duration) {
        return ShareCommandExecutor.executeShare(ctx, ShowcaseManager.ShareType.HOTBAR, null, null, (player, unused, dur, recv) -> ShowcaseManager.createHotbarShare(player, dur, recv), TextUtils.HOTBAR, description, receivers, duration);
    }

    public static int shareEnderChest(CommandContext<class_2168> ctx, class_3222 sourcePlayer, String description, Collection<class_3222> receivers, Integer duration) {
        return ShareCommandExecutor.executeShare(ctx, ShowcaseManager.ShareType.ENDER_CHEST, null, null, (player, unused, dur, recv) -> ShowcaseManager.createEnderChestShare(player, dur, recv), TextUtils.ENDER_CHEST, description, receivers, duration);
    }

    public static int shareContainer(CommandContext<class_2168> ctx, String description, Collection<class_3222> receivers, Integer duration) {
        class_3222 sender = ShareCommandUtils.getSenderPlayer(ctx);
        if (sender == null) {
            return 0;
        }
        if (ShowcaseManager.isOnCooldown(sender, ShowcaseManager.ShareType.CONTAINER)) {
            return 0;
        }
        int durationSeconds = ModConfigManager.getShareSettings((ShowcaseManager.ShareType)ShowcaseManager.ShareType.CONTAINER).listeningDuration;
        class_5250 message = class_2561.method_43469((String)"showcase.message.share_container_tip", (Object[])new Object[]{durationSeconds});
        sender.method_7353((class_2561)message, true);
        CountdownBossBar countdown = new CountdownBossBar(sender, (class_2561)message, durationSeconds);
        countdown.start();
        CountdownBossBarManager.add(countdown);
        ContainerOpenWatcher.awaitContainerOpened(sender, durationSeconds, (player, inventory) -> {
            String shareId = ShowcaseManager.createContainerShare(player, inventory, duration, receivers);
            ShareCommandUtils.sendShareMessage(sender, player, receivers, description, ShowcaseManager.ShareType.CONTAINER, inventory.getName(), duration, shareId);
            ShowcaseManager.setCooldown(sender, ShowcaseManager.ShareType.CONTAINER);
            CountdownBossBarManager.remove(countdown);
        }, () -> {
            sender.method_7353(TextUtils.warning((class_2561)class_2561.method_43471((String)"showcase.message.share_container_expiry")), true);
            CountdownBossBarManager.remove(countdown);
        });
        return 1;
    }

    public static int shareMerchant(CommandContext<class_2168> ctx, String description, Collection<class_3222> receivers, Integer duration) {
        class_3222 sender = ShareCommandUtils.getSenderPlayer(ctx);
        if (sender == null) {
            return 0;
        }
        if (ShowcaseManager.isOnCooldown(sender, ShowcaseManager.ShareType.MERCHANT)) {
            return 0;
        }
        int durationSeconds = ModConfigManager.getShareSettings((ShowcaseManager.ShareType)ShowcaseManager.ShareType.MERCHANT).listeningDuration;
        class_5250 message = class_2561.method_43469((String)"showcase.message.share_merchant_tip", (Object[])new Object[]{durationSeconds});
        sender.method_7353((class_2561)message, true);
        CountdownBossBar countdown = new CountdownBossBar(sender, (class_2561)message, durationSeconds);
        countdown.start();
        CountdownBossBarManager.add(countdown);
        ContainerOpenWatcher.awaitMerchantGuiOpened(sender, durationSeconds, (player, merchantContext) -> {
            String shareId = ShowcaseManager.createMerchantShare(player, merchantContext, duration, receivers);
            ShareCommandUtils.sendShareMessage(sender, player, receivers, description, ShowcaseManager.ShareType.MERCHANT, merchantContext.getFullDisplayName(), duration, shareId);
            ShowcaseManager.setCooldown(sender, ShowcaseManager.ShareType.MERCHANT);
            CountdownBossBarManager.remove(countdown);
        }, () -> {
            sender.method_7353(TextUtils.warning((class_2561)class_2561.method_43471((String)"showcase.message.share_merchant_expiry")), true);
            CountdownBossBarManager.remove(countdown);
        });
        return 1;
    }

    private static int cancelShare(class_3222 player, String id) {
        if (player == null) {
            return 0;
        }
        ShareEntry entry = ShowcaseManager.getShareById(id);
        if (entry == null) {
            player.method_64398(TextUtils.error((class_2561)class_2561.method_43471((String)"showcase.message.invalid_id")));
            return 0;
        }
        if (!entry.getOwnerUuid().equals(player.method_5667())) {
            player.method_64398(TextUtils.warning((class_2561)class_2561.method_43471((String)"showcase.message.cancel_not_owner")));
            return 0;
        }
        boolean success = ShowcaseManager.expireShareById(id);
        class_2561 message = success ? TextUtils.success((class_2561)class_2561.method_43471((String)"showcase.message.cancel_success")) : TextUtils.error((class_2561)class_2561.method_43471((String)"showcase.message.cancel_failed"));
        player.method_64398(message);
        return success ? 1 : 0;
    }

    private static int getValidatedDuration(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int requested;
        String timeString = StringArgumentType.getString(ctx, (String)"duration");
        try {
            requested = TimeUtils.parseTimeToSeconds(timeString);
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"showcase.command.invalid_time_format")).create();
        }
        int min = ModConfigManager.getShareLinkMinExpiry();
        int max = ModConfigManager.getShareLinkDefaultExpiry();
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (PermissionChecker.isOp(player)) {
            return requested;
        }
        if (requested < min || requested > max) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"showcase.message.invalid_duration_exception", (Object[])new Object[]{min, max})).create();
        }
        return requested;
    }

    @FunctionalInterface
    private static interface ShareExecutor {
        public int execute(CommandContext<class_2168> var1, class_3222 var2, String var3, Collection<class_3222> var4, Integer var5);
    }

    @FunctionalInterface
    private static interface SimpleShareExecutor {
        public int execute(CommandContext<class_2168> var1, String var2, Collection<class_3222> var3, Integer var4);
    }

    private static interface QuadFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }
}

