/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.config;

import com.showcase.ShowcaseMod;
import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfig;
import com.showcase.config.ModConfigManager;
import com.showcase.utils.DevUtils;
import java.nio.file.Path;
import java.util.Map;

public class ConfigValidationTest {
    public static void runValidationTests() {
        if (DevUtils.isProduction()) {
            ShowcaseMod.LOGGER.warn("Configuration validation tests are only available in development environment");
            return;
        }
        ShowcaseMod.LOGGER.info("Starting configuration validation tests...");
        ConfigValidationTest.testDefaultConfigValidation();
        ConfigValidationTest.testInvalidConfigRecovery();
        ConfigValidationTest.testBackupFunctionality();
        ShowcaseMod.LOGGER.info("Configuration validation tests completed");
    }

    private static void testDefaultConfigValidation() {
        ShowcaseMod.LOGGER.info("Test 1: Default configuration validation");
        try {
            ModConfig defaultConfig = new ModConfig();
            boolean isValid = ModConfigManager.isCurrentConfigValid();
            if (isValid) {
                ShowcaseMod.LOGGER.info("\u2713 Default configuration is valid");
            } else {
                ShowcaseMod.LOGGER.error("\u2717 Default configuration failed validation");
            }
            for (ShowcaseManager.ShareType shareType : ShowcaseManager.ShareType.values()) {
                if (defaultConfig.shareSettings.containsKey((Object)shareType)) {
                    ShowcaseMod.LOGGER.debug("\u2713 Share type {} configured", (Object)shareType);
                    continue;
                }
                ShowcaseMod.LOGGER.error("\u2717 Missing configuration for share type {}", (Object)shareType);
            }
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("\u2717 Exception during default config test", (Throwable)e);
        }
    }

    private static void testInvalidConfigRecovery() {
        ShowcaseMod.LOGGER.info("Test 2: Invalid configuration recovery");
        try {
            ModConfig invalidConfig = new ModConfig();
            invalidConfig.placeholders.maxSharesPerPlayer = -1;
            invalidConfig.shareLink.minExpiryTime = -1;
            ShowcaseMod.LOGGER.info("\u2713 Invalid configuration recovery test setup complete");
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("\u2717 Exception during invalid config test", (Throwable)e);
        }
    }

    private static void testBackupFunctionality() {
        ShowcaseMod.LOGGER.info("Test 3: Backup functionality");
        try {
            boolean backupSuccess = ModConfigManager.createConfigBackup("test");
            if (backupSuccess) {
                ShowcaseMod.LOGGER.info("\u2713 Configuration backup created successfully");
            } else {
                ShowcaseMod.LOGGER.warn("\u26a0 Configuration backup creation returned false (may not exist yet)");
            }
            Path backupDir = ModConfigManager.getBackupDirectory();
            if (backupDir != null) {
                ShowcaseMod.LOGGER.info("\u2713 Backup directory accessible: {}", (Object)backupDir);
            } else {
                ShowcaseMod.LOGGER.error("\u2717 Backup directory is null");
            }
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("\u2717 Exception during backup test", (Throwable)e);
        }
    }

    public static boolean validateConfiguration(ModConfig config) {
        if (config == null) {
            ShowcaseMod.LOGGER.warn("Configuration is null");
            return false;
        }
        try {
            if (config.shareSettings == null || config.shareSettings.isEmpty()) {
                ShowcaseMod.LOGGER.warn("Share settings missing");
                return false;
            }
            for (ShowcaseManager.ShareType shareType : ShowcaseManager.ShareType.values()) {
                ModConfig.ShareSettings settings = config.shareSettings.get((Object)shareType);
                if (settings == null) {
                    ShowcaseMod.LOGGER.warn("Missing settings for {}", (Object)shareType);
                    return false;
                }
                if (settings.cooldown < 0) {
                    ShowcaseMod.LOGGER.warn("Invalid cooldown for {}: {}", (Object)shareType, (Object)settings.cooldown);
                    return false;
                }
                if (settings.defaultPermission >= 0 && settings.defaultPermission <= 4) continue;
                ShowcaseMod.LOGGER.warn("Invalid permission for {}: {}", (Object)shareType, (Object)settings.defaultPermission);
                return false;
            }
            if (config.shareLink == null) {
                ShowcaseMod.LOGGER.warn("Share link settings missing");
                return false;
            }
            if (config.shareLink.minExpiryTime <= 0 || config.shareLink.defaultExpiryTime <= 0) {
                ShowcaseMod.LOGGER.warn("Invalid expiry times");
                return false;
            }
            if (config.placeholders == null) {
                ShowcaseMod.LOGGER.warn("Placeholder settings missing");
                return false;
            }
            if (config.placeholders.maxSharesPerPlayer <= 0) {
                ShowcaseMod.LOGGER.warn("Invalid max shares per player: {}", (Object)config.placeholders.maxSharesPerPlayer);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Exception during manual validation", (Throwable)e);
            return false;
        }
    }

    public static void printConfigSummary(ModConfig config) {
        if (config == null) {
            ShowcaseMod.LOGGER.info("Configuration is null");
            return;
        }
        ShowcaseMod.LOGGER.info("=== Configuration Summary ===");
        ShowcaseMod.LOGGER.info("Map view duration: {}", (Object)config.mapViewDuration);
        ShowcaseMod.LOGGER.info("Item view duration: {}", (Object)config.itemViewDuration);
        ShowcaseMod.LOGGER.info("Max placeholders per message: {}", (Object)config.maxPlaceholdersPerMessage);
        if (config.shareSettings != null) {
            ShowcaseMod.LOGGER.info("Share types configured: {}", (Object)config.shareSettings.size());
            for (Map.Entry<ShowcaseManager.ShareType, ModConfig.ShareSettings> entry : config.shareSettings.entrySet()) {
                ShowcaseMod.LOGGER.info("  {}: cooldown={}s, permission={}", new Object[]{entry.getKey(), entry.getValue().cooldown, entry.getValue().defaultPermission});
            }
        }
        if (config.placeholders != null) {
            ShowcaseMod.LOGGER.info("Max shares per player: {}", (Object)config.placeholders.maxSharesPerPlayer);
            ShowcaseMod.LOGGER.info("Placeholder cache duration: {}s", (Object)config.placeholders.cacheDuration);
        }
        ShowcaseMod.LOGGER.info("=============================");
    }
}

