/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.config;

import com.showcase.command.ShowcaseManager;
import de.exlll.configlib.Comment;
import de.exlll.configlib.Configuration;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

@Configuration
public class ModConfig {
    @Comment(value={"Map view mode configuration:", "-1: Disable map preview functionality", "0: Use map preview with no time limit", ">0: Use map preview with specified duration in seconds"})
    public int mapViewDuration = 10;
    @Comment(value={"Item view mode configuration:", "-1: Use traditional container view (no time limit)", "0: Use hotbar preview with no time limit", ">0: Use hotbar preview with specified duration in seconds"})
    public int itemViewDuration = -1;
    @Comment(value={"The maximum number of placeholders that can be replaced in a single chat message."})
    public int maxPlaceholdersPerMessage = 2;
    @Comment(value={"Per-share type settings."})
    public Map<ShowcaseManager.ShareType, ShareSettings> shareSettings = ModConfig.defaultShareSettings();
    @Comment(value={"Share link related configuration"})
    public ShareLinkSettings shareLink = new ShareLinkSettings();
    @Comment(value={"Settings related to how player statistics are displayed"})
    public StatsDisplaySettings statsDisplay = new StatsDisplaySettings();
    @Comment(value={"Settings for item icons in showcase messages"})
    public ItemIconSettings itemIcons = new ItemIconSettings();
    @Comment(value={"Settings for extended placeholder functionality"})
    public PlaceholderSettings placeholders = new PlaceholderSettings();

    private static Map<ShowcaseManager.ShareType, ShareSettings> defaultShareSettings() {
        EnumMap<ShowcaseManager.ShareType, ShareSettings> defaults = new EnumMap<ShowcaseManager.ShareType, ShareSettings>(ShowcaseManager.ShareType.class);
        ModConfig.add(defaults, ShowcaseManager.ShareType.ITEM, 10, 0, Arrays.asList("item", "i"), -1);
        ModConfig.add(defaults, ShowcaseManager.ShareType.INVENTORY, 10, 0, Arrays.asList("inventory", "inv"), -1);
        ModConfig.add(defaults, ShowcaseManager.ShareType.HOTBAR, 10, 0, Arrays.asList("hotbar", "hb"), -1);
        ModConfig.add(defaults, ShowcaseManager.ShareType.ENDER_CHEST, 10, 0, Arrays.asList("ender_chest", "ec"), -1);
        ModConfig.add(defaults, ShowcaseManager.ShareType.STATS, 10, 0, List.of("stats", "statistical", "stat"), -1);
        ModConfig.add(defaults, ShowcaseManager.ShareType.CONTAINER, 10, 0, List.of(), 10);
        ModConfig.add(defaults, ShowcaseManager.ShareType.MERCHANT, 10, 0, List.of(), 10);
        return defaults;
    }

    private static void add(Map<ShowcaseManager.ShareType, ShareSettings> map, ShowcaseManager.ShareType type, int cooldown, int perm, List<String> keywords, int listeningDuration) {
        map.put(type, new ShareSettings(cooldown, perm, keywords, listeningDuration));
    }

    @Configuration
    public static class ShareLinkSettings {
        @Comment(value={"Minimum expiry time in seconds for share links"})
        public int minExpiryTime = 60;
        @Comment(value={"Default expiry time in seconds for share links"})
        public int defaultExpiryTime = 300;
        @Comment(value={"Enable underline for clickable text messages"})
        public boolean enableClickableTextUnderline = false;
    }

    @Configuration
    public static class StatsDisplaySettings {
        @Comment(value={"Whether to show time-related statistics (play time, death time, rest time, etc.)"})
        public boolean showTimeStats = true;
        @Comment(value={"Whether to show movement-related statistics (walking, running, swimming, etc.)"})
        public boolean showMovementStats = true;
        @Comment(value={"Whether to show combat-related statistics (damage dealt/taken, kills, deaths, etc.)"})
        public boolean showCombatStats = true;
        @Comment(value={"Whether to show interaction statistics (trading, breeding, container interactions, etc.)"})
        public boolean showInteractionStats = true;
        @Comment(value={"Whether to show miscellaneous statistics (drops, cauldron usage, note blocks, etc.)"})
        public boolean showMiscStats = true;
        @Comment(value={"Maximum number of statistics to display per category in the book"})
        public int maxStatsPerCategory = 15;
        @Comment(value={"Whether to sort statistics by value (highest first) within each category"})
        public boolean sortStatsByValue = true;
        @Comment(value={"Whether to hide statistics with zero values"})
        public boolean hideZeroStats = true;
        @Comment(value={"Whether to show only the top statistics in each category"})
        public boolean showOnlyTopStats = false;
        @Comment(value={"Number of top statistics to show when showOnlyTopStats is enabled"})
        public int topStatsCount = 10;
        @Comment(value={"Custom formatting settings for time display"})
        public TimeFormatSettings timeFormat = new TimeFormatSettings();
        @Comment(value={"Custom formatting settings for distance display"})
        public DistanceFormatSettings distanceFormat = new DistanceFormatSettings();
        @Comment(value={"Custom formatting settings for damage display"})
        public DamageFormatSettings damageFormat = new DamageFormatSettings();
    }

    @Configuration
    public static class ItemIconSettings {
        @Comment(value={"Enable item icons in showcase messages"})
        public boolean enabled = false;
        @Comment(value={"Font namespace for item icons (e.g., 'custom', 'showcase')"})
        public String fontNamespace = "iconifycraft";
        @Comment(value={"Include item icons in item names"})
        public boolean includeInItemNames = true;
    }

    @Configuration
    public static class PlaceholderSettings {
        @Comment(value={"Enable extended placeholder functionality"})
        public boolean enabled = true;
        @Comment(value={"Maximum number of active shares per player"})
        public int maxSharesPerPlayer = 10;
        @Comment(value={"Cache duration for placeholder results in seconds"})
        public int cacheDuration = 30;
        @Comment(value={"Enable player statistics tracking for placeholders"})
        public boolean enableStatisticsTracking = true;
        @Comment(value={"Enable server-wide statistics for placeholders"})
        public boolean enableServerStatistics = true;
        @Comment(value={"Enable performance metrics tracking"})
        public boolean enablePerformanceMetrics = true;
        @Comment(value={"How often to update statistics cache in seconds"})
        public int statisticsUpdateInterval = 60;
        @Comment(value={"Enable conditional placeholders (if_xxx_yes_no style)"})
        public boolean enableConditionalPlaceholders = true;
    }

    @Configuration
    public static class ShareSettings {
        @Comment(value={"Cooldown time in seconds."})
        public int cooldown;
        @Comment(value={"Default permission level (0-4)."})
        public int defaultPermission;
        @Comment(value={"Trigger keywords for this share type (not available for CONTAINER and MERCHANT)."})
        public List<String> keywords;
        @Comment(value={"Listening duration in seconds (only for CONTAINER and MERCHANT). Set -1 if not applicable."})
        public int listeningDuration;

        public ShareSettings() {
        }

        public ShareSettings(int cooldown, int defaultPermission, List<String> keywords, int listeningDuration) {
            this.cooldown = cooldown;
            this.defaultPermission = defaultPermission;
            this.keywords = keywords;
            this.listeningDuration = listeningDuration;
        }
    }

    @Configuration
    public static class DamageFormatSettings {
        @Comment(value={"Whether to show damage as hearts (\u2665) instead of raw damage points"})
        public boolean showAsHearts = true;
        @Comment(value={"Number of decimal places for heart display"})
        public int heartDecimalPlaces = 1;
        @Comment(value={"Whether to show both hearts and raw damage (e.g., '5.0\u2665 (50)')"})
        public boolean showBothFormats = false;
    }

    @Configuration
    public static class DistanceFormatSettings {
        @Comment(value={"Whether to automatically convert centimeters to meters/kilometers"})
        public boolean autoConvert = true;
        @Comment(value={"Threshold in centimeters above which to convert to meters (default: 100cm = 1m)"})
        public int meterThreshold = 100;
        @Comment(value={"Threshold in centimeters above which to convert to kilometers (default: 100000cm = 1km)"})
        public int kilometerThreshold = 100000;
        @Comment(value={"Number of decimal places for meter display"})
        public int meterDecimalPlaces = 1;
        @Comment(value={"Number of decimal places for kilometer display"})
        public int kilometerDecimalPlaces = 2;
    }

    @Configuration
    public static class TimeFormatSettings {
        @Comment(value={"Whether to use compact time format (e.g., '1h 30m' instead of '1 hour 30 minutes')"})
        public boolean useCompactFormat = true;
        @Comment(value={"Whether to show seconds when displaying time under 1 minute"})
        public boolean showSecondsUnderMinute = true;
        @Comment(value={"Whether to hide zero components (e.g., show '1h 5s' instead of '1h 0m 5s')"})
        public boolean hideZeroComponents = true;
    }
}

