/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.showcase.ShowcaseMod;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public record JsonCodecDataStorage<T>(String path, Codec<T> codec) {
    private static final String DIR = "global-mod-data";

    public boolean save(MinecraftServer server, T data) {
        Path globalPath = server.method_27050(class_5218.field_24188).resolve(DIR);
        Path filePath = globalPath.resolve(this.path + ".json");
        if (data == null) {
            try {
                return Files.deleteIfExists(filePath);
            }
            catch (IOException e) {
                ShowcaseMod.LOGGER.error("Failed to delete global data file at {}\n{}", (Object)filePath, (Object)e.fillInStackTrace());
                return false;
            }
        }
        try {
            if (!Files.exists(globalPath, new LinkOption[0])) {
                Files.createDirectories(globalPath, new FileAttribute[0]);
            }
            JsonElement encoded = (JsonElement)this.codec.encodeStart((DynamicOps)server.method_30611().method_57093((DynamicOps)JsonOps.INSTANCE), data).getOrThrow();
            Files.writeString(filePath, (CharSequence)encoded.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            ShowcaseMod.LOGGER.error("IOException while saving global data for path {}\n{}", (Object)this.path, (Object)e.fillInStackTrace());
            return false;
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Unexpected error while saving global data for path {}\n{}", (Object)this.path, (Object)e.fillInStackTrace());
            return false;
        }
    }

    public T load(MinecraftServer server) {
        Path filePath = server.method_27050(class_5218.field_24188).resolve(DIR).resolve(this.path + ".json");
        if (!Files.exists(filePath, new LinkOption[0])) {
            return null;
        }
        try {
            String jsonString = Files.readString(filePath, StandardCharsets.UTF_8);
            JsonElement element = JsonParser.parseString((String)jsonString);
            DataResult decoded = this.codec.decode((DynamicOps)server.method_30611().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)element);
            if (decoded.result().isEmpty()) {
                ShowcaseMod.LOGGER.error("Decoding failed or returned empty for global data at path {}", (Object)this.path);
                if (decoded.error().isPresent()) {
                    ShowcaseMod.LOGGER.error("Decoding error details: {}", decoded.error().get());
                }
                this.createCorruptedBackup(filePath, jsonString);
                return null;
            }
            return decoded.result().map(Pair::getFirst).orElse(null);
        }
        catch (IOException e) {
            ShowcaseMod.LOGGER.error("IOException while loading global data for path {}", (Object)this.path, (Object)e);
            return null;
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Unexpected error while loading global data for path {}", (Object)this.path, (Object)e);
            return null;
        }
    }

    private void createCorruptedBackup(Path originalPath, String jsonContent) {
        try {
            Path backupPath = originalPath.getParent().resolve(originalPath.getFileName().toString() + ".corrupted." + System.currentTimeMillis());
            Files.writeString(backupPath, (CharSequence)jsonContent, StandardCharsets.UTF_8, new OpenOption[0]);
            ShowcaseMod.LOGGER.info("Created backup of corrupted file at: {}", (Object)backupPath);
            Files.deleteIfExists(originalPath);
            ShowcaseMod.LOGGER.info("Deleted corrupted file: {}", (Object)originalPath);
        }
        catch (IOException e) {
            ShowcaseMod.LOGGER.error("Failed to create backup of corrupted file", (Throwable)e);
        }
    }
}

