/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfigManager;
import com.showcase.gui.MerchantContext;
import com.showcase.utils.PlayerUtils;
import com.showcase.utils.ReadOnlyInventory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;

public class ShareEntry {
    private final UUID ownerUuid;
    private final ShowcaseManager.ShareType type;
    private final ReadOnlyInventory inventory;
    private final MerchantContext merchantContext;
    private final long timestamp;
    private final int duration;
    private int viewCount;
    private boolean isInvalid;
    private final Set<UUID> receiverUuids;
    public static final Codec<ShareEntry> SHARE_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("ownerUuid").forGetter(ShareEntry::getOwnerUuid), (App)Codec.STRING.xmap(ShowcaseManager.ShareType::valueOf, Enum::name).fieldOf("type").forGetter(ShareEntry::getType), (App)ReadOnlyInventory.READ_ONLY_INVENTORY_CODEC.optionalFieldOf("inventory").forGetter(entry -> Optional.ofNullable(entry.getInventory())), (App)MerchantContext.MERCHANT_CONTEXT_CODEC.optionalFieldOf("merchantContext").forGetter(entry -> Optional.ofNullable(entry.getMerchantContext())), (App)Codec.LONG.fieldOf("timestamp").forGetter(ShareEntry::getTimestamp), (App)Codec.INT.fieldOf("duration").forGetter(ShareEntry::getDuration), (App)Codec.INT.fieldOf("viewCount").forGetter(ShareEntry::getViewCount), (App)Codec.BOOL.fieldOf("isInvalid").forGetter(ShareEntry::getIsInvalid), (App)Codec.list((Codec)Codec.STRING.xmap(UUID::fromString, UUID::toString)).fieldOf("receivers").forGetter(entry -> new ArrayList<UUID>(entry.receiverUuids))).apply((Applicative)instance, (ownerUuid, type, inventoryOpt, merchantContextOpt, timestamp, duration, viewCount, isInvalid, receiverList) -> new ShareEntry((UUID)ownerUuid, (ShowcaseManager.ShareType)((Object)((Object)type)), inventoryOpt.orElse(null), merchantContextOpt.orElse(null), (long)timestamp, (int)duration, (int)viewCount, (boolean)isInvalid, (Set<UUID>)new HashSet<UUID>((Collection<UUID>)receiverList))));

    public ShareEntry(UUID ownerUuid, ShowcaseManager.ShareType type, ReadOnlyInventory inventory, MerchantContext merchantContext, long timestamp, int duration, int viewCount, boolean isInvalid, Set<UUID> receiverUuids) {
        this.ownerUuid = ownerUuid;
        this.type = type;
        this.inventory = inventory;
        this.merchantContext = merchantContext;
        this.timestamp = timestamp;
        this.duration = duration;
        this.viewCount = viewCount;
        this.isInvalid = isInvalid;
        this.receiverUuids = receiverUuids != null ? receiverUuids : new HashSet();
    }

    public ShareEntry(UUID ownerUuid, ShowcaseManager.ShareType type, MerchantContext merchantContext, Integer duration, Collection<class_3222> receivers) {
        this(ownerUuid, type, null, merchantContext, Instant.now().toEpochMilli(), duration == null ? ModConfigManager.getShareLinkDefaultExpiry() : duration, 0, false, PlayerUtils.getReceiverUuids(receivers));
    }

    public ShareEntry(UUID ownerUuid, ShowcaseManager.ShareType type, ReadOnlyInventory inventory, Integer duration, Collection<class_3222> receivers) {
        this(ownerUuid, type, inventory, null, Instant.now().toEpochMilli(), duration == null ? ModConfigManager.getShareLinkDefaultExpiry() : duration, 0, false, PlayerUtils.getReceiverUuids(receivers));
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public ShowcaseManager.ShareType getType() {
        return this.type;
    }

    public ReadOnlyInventory getInventory() {
        return this.inventory;
    }

    public MerchantContext getMerchantContext() {
        return this.merchantContext;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    public boolean getIsInvalid() {
        return this.isInvalid;
    }

    public Set<UUID> getReceiverUuids() {
        return this.receiverUuids;
    }

    public void incrementViewCount() {
        ++this.viewCount;
    }

    public void invalidShare() {
        this.isInvalid = true;
    }

    public void addReceiver(class_3222 player) {
        this.receiverUuids.add(player.method_5667());
    }

    public void removeReceiver(class_3222 player) {
        this.receiverUuids.remove(player.method_5667());
    }

    public Collection<class_3222> getReceiver(MinecraftServer server) {
        return this.receiverUuids.stream().map(arg_0 -> ((class_3324)server.method_3760()).method_14602(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Set<UUID> getUuidOfReceiverPlayers() {
        return this.receiverUuids;
    }
}

