/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.gui;

import com.showcase.gui.BaseViewerContext;
import com.showcase.utils.compat.GuiElementBuilderCompat;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.HotbarGui;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

public abstract class BaseWorldGui
extends HotbarGui {
    protected BaseViewerContext context;
    private final int currentBlockClickTick;

    public BaseWorldGui(BaseViewerContext context, int selectedSlot) {
        super(context.player);
        this.setSelectedSlot(selectedSlot);
        this.context = context;
        this.currentBlockClickTick = context.player.field_6012;
    }

    public void onTick() {
        this.checkClosed();
        super.onTick();
    }

    private void checkClosed() {
        if (this.context.checkClosed()) {
            this.close();
        }
    }

    public boolean onClickBlock(class_3965 hitResult) {
        this.checkClosed();
        if (this.player.field_6012 - this.currentBlockClickTick >= 5) {
            return super.onClickBlock(hitResult);
        }
        return false;
    }

    public void onClickItem() {
        this.checkClosed();
        if (this.player.field_6012 - this.currentBlockClickTick >= 5) {
            super.onClickItem();
        }
    }

    public boolean onHandSwing() {
        if (this.player.field_6012 - this.currentBlockClickTick >= 5) {
            return super.onHandSwing();
        }
        return false;
    }

    protected void rebuildUi() {
        for (int i = 0; i < this.size; ++i) {
            this.clearSlot(i);
        }
        this.buildUi();
        this.setSlot(8, (GuiElementBuilderInterface)GuiElementBuilderCompat.setModel(new GuiElementBuilder(), class_1802.field_8077).setName((class_2561)class_2561.method_43471((String)(this.context.interfaceList.isEmpty() ? "mco.notification.dismiss" : "gui.back"))).setRarity(class_1814.field_8906).hideDefaultTooltip().setCallback((x, y, z, c) -> {
            this.playClickSound();
            if (this.context == null || this.context.interfaceList.isEmpty()) {
                this.close();
            } else {
                this.switchUi(this.context.interfaceList.removeFirst(), false);
            }
        }));
        this.setSlot(37, this.player.method_6118(class_1304.field_6169).method_7972());
        this.setSlot(38, this.player.method_6118(class_1304.field_6174).method_7972());
        this.setSlot(39, this.player.method_6118(class_1304.field_6172).method_7972());
        this.setSlot(40, this.player.method_6118(class_1304.field_6166).method_7972());
    }

    public void setSelectedSlot(int value) {
        this.selectedSlot = class_3532.method_15340((int)value, (int)0, (int)8);
    }

    protected void playClickSound() {
        this.playSound();
    }

    public boolean onClick(int index, ClickType type, class_1713 action, GuiElementInterface element) {
        if (type == ClickType.DROP || type == ClickType.CTRL_DROP) {
            this.close();
            return true;
        }
        return super.onClick(index, type, action, element);
    }

    protected abstract void buildUi();

    protected abstract BaseViewerContext.SwitchEntry asSwitchableUi();

    protected GuiElementBuilder baseElement(class_1799 itemStack, String name, boolean selected) {
        GuiElementBuilder builder = new GuiElementBuilder(itemStack);
        if (selected) {
            builder.glow();
        }
        return builder;
    }

    protected GuiElementBuilder baseElement(class_1792 item, class_5250 text, boolean selected) {
        GuiElementBuilder builder = GuiElementBuilderCompat.setModel(new GuiElementBuilder(), item).setName((class_2561)text.method_27692(class_124.field_1068)).hideDefaultTooltip();
        if (selected) {
            builder.glow();
        }
        return builder;
    }

    protected GuiElementBuilder switchElement(class_1792 item, String name, BaseViewerContext.SwitchableUi ui) {
        return GuiElementBuilderCompat.setModel(new GuiElementBuilder(), item).setName((class_2561)class_2561.method_43470((String)("entry." + name)).method_27692(class_124.field_1068)).hideDefaultTooltip().setCallback(this.switchCallback(ui));
    }

    protected GuiElementInterface.ClickCallback switchCallback(BaseViewerContext.SwitchableUi ui) {
        return (x, y, z, c) -> {
            this.playSound();
            this.switchUi(new BaseViewerContext.SwitchEntry(ui, 0), true);
        };
    }

    public void switchUi(BaseViewerContext.SwitchEntry uiOpener, boolean addSelf) {
        BaseViewerContext context = this.context;
        if (addSelf) {
            context.interfaceList.addFirst(this.asSwitchableUi());
        }
        this.context = null;
        uiOpener.open(context);
    }

    public void onClose() {
        if (this.context != null) {
            this.context.close();
        }
    }

    protected void playSound() {
        this.player.field_13987.method_14364((class_2596)new class_2767((class_6880)class_3417.field_15015, class_3419.field_15250, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), 0.5f, 1.0f, 0L));
    }
}

