/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.gui;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.showcase.utils.compat.VillagerCompat;
import net.minecraft.class_1646;
import net.minecraft.class_1916;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_8824;

public final class MerchantContext {
    private final class_1916 offers;
    private final int level;
    private final int experience;
    private final boolean isLeveled;
    private final class_2561 displayName;
    public static final Codec<MerchantContext> MERCHANT_CONTEXT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1916.field_48850.fieldOf("offers").forGetter(MerchantContext::getOffers), (App)Codec.INT.fieldOf("level").forGetter(MerchantContext::getLevel), (App)Codec.INT.fieldOf("experience").forGetter(MerchantContext::getExperience), (App)Codec.BOOL.fieldOf("isLeveled").forGetter(MerchantContext::isLeveled), (App)class_8824.field_46597.fieldOf("displayName").forGetter(MerchantContext::getDisplayName)).apply((Applicative)instance, MerchantContext::new));

    public MerchantContext(class_1646 villager) {
        this.offers = villager.method_8264() != null ? villager.method_8264() : new class_1916();
        this.level = VillagerCompat.getLevel(villager.method_7231());
        this.experience = villager.method_19269();
        this.isLeveled = true;
        this.displayName = villager.method_5476() != null ? villager.method_5476() : class_2561.method_43473();
    }

    public MerchantContext(class_1916 offers, int level, int experience, boolean isLeveled, class_2561 displayName) {
        this.offers = offers;
        this.level = level;
        this.experience = experience;
        this.isLeveled = isLeveled;
        this.displayName = displayName;
    }

    public class_5250 getLevelText() {
        return class_2561.method_43471((String)("merchant.level." + Math.max(1, Math.min(5, this.level))));
    }

    public class_2561 getFullDisplayName() {
        if (!this.isLeveled) {
            return this.getDisplayName();
        }
        return class_2561.method_43469((String)"merchant.title", (Object[])new Object[]{this.getDisplayName(), this.getLevelText()});
    }

    public class_1916 getOffers() {
        return this.offers;
    }

    public int getLevel() {
        return this.level;
    }

    public int getExperience() {
        return this.experience;
    }

    public boolean isLeveled() {
        return this.isLeveled;
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }
}

