/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.listener;

import com.showcase.ShowcaseMod;
import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfig;
import com.showcase.config.ModConfigManager;
import com.showcase.placeholders.Placeholders;
import com.showcase.utils.permissions.PermissionChecker;
import com.showcase.utils.permissions.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ChatKeywordHandler {
    private final ModConfig config;
    private final Map<String, ShowcaseManager.ShareType> keywordToTypeMap;
    private final Pattern keywordPattern;
    public static final Set<String> SUPPORTED_PLACEHOLDERS;
    private static final Map<ShowcaseManager.ShareType, String> PLACEHOLDER_CACHE;
    private static final Map<ShowcaseManager.ShareType, class_2960> TYPE_TO_IDENTIFIER;

    public ChatKeywordHandler(ModConfig config) {
        this.config = config;
        this.keywordToTypeMap = this.buildKeywordMap();
        this.keywordPattern = this.buildKeywordPattern();
    }

    private Map<String, ShowcaseManager.ShareType> buildKeywordMap() {
        HashMap<String, ShowcaseManager.ShareType> map = new HashMap<String, ShowcaseManager.ShareType>();
        HashSet duplicates = new HashSet();
        this.config.shareSettings.forEach((type, settings) -> {
            if (settings == null || settings.keywords == null) {
                return;
            }
            for (String keyword : settings.keywords) {
                String normalized;
                ShowcaseManager.ShareType old;
                if (keyword == null || keyword.isBlank() || (old = map.putIfAbsent(normalized = keyword.toLowerCase(Locale.ROOT).trim(), (ShowcaseManager.ShareType)((Object)type))) == null || old == type) continue;
                duplicates.add(normalized);
            }
        });
        if (!duplicates.isEmpty()) {
            String msg = "Duplicate keywords found in config: " + String.valueOf(duplicates);
            ShowcaseMod.LOGGER.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return map;
    }

    private Pattern buildKeywordPattern() {
        if (this.keywordToTypeMap.isEmpty()) {
            return Pattern.compile("(?!)");
        }
        String joined = this.keywordToTypeMap.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
        return Pattern.compile("\\[\\s*(" + joined + ")\\s*]", 2);
    }

    public String processMessage(String originalMessage, class_3222 player) {
        if (originalMessage == null || originalMessage.isBlank()) {
            return originalMessage;
        }
        Matcher matcher = this.keywordPattern.matcher(originalMessage);
        if (!matcher.find()) {
            return originalMessage;
        }
        int maxReplacements = ModConfigManager.getConfig().maxPlaceholdersPerMessage;
        int replacements = 0;
        StringBuilder result = new StringBuilder();
        matcher.reset();
        while (matcher.find()) {
            if (replacements >= maxReplacements && !PermissionChecker.isOp(player)) {
                matcher.appendReplacement(result, Matcher.quoteReplacement(matcher.group(0)));
                continue;
            }
            String keyword = matcher.group(1).toLowerCase(Locale.ROOT).trim();
            ShowcaseManager.ShareType shareType = this.keywordToTypeMap.get(keyword);
            if (shareType == null || !this.hasPermission(player, shareType)) {
                matcher.appendReplacement(result, Matcher.quoteReplacement(matcher.group(0)));
                continue;
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(ChatKeywordHandler.getCachedPlaceholder(shareType)));
            ++replacements;
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String getCachedPlaceholder(ShowcaseManager.ShareType shareType) {
        String placeholder = PLACEHOLDER_CACHE.get((Object)shareType);
        if (placeholder == null) {
            throw new IllegalArgumentException("No placeholder cached for share type: " + String.valueOf((Object)shareType));
        }
        return placeholder;
    }

    public static Set<String> getSupportedPlaceholders() {
        return SUPPORTED_PLACEHOLDERS;
    }

    private boolean hasPermission(class_3222 player, ShowcaseManager.ShareType shareType) {
        ModConfig.ShareSettings settings = this.config.shareSettings.get((Object)shareType);
        return settings != null && PermissionChecker.hasPermission(player, Permissions.getCommandTypeFromShareType(shareType).getPermission(), settings.defaultPermission);
    }

    public Map<ShowcaseManager.ShareType, List<String>> getSupportedKeywords() {
        EnumMap<ShowcaseManager.ShareType, List<String>> result = new EnumMap<ShowcaseManager.ShareType, List<String>>(ShowcaseManager.ShareType.class);
        this.config.shareSettings.forEach((type, settings) -> {
            ArrayList<String> keywords = settings != null && settings.keywords != null ? new ArrayList<String>(settings.keywords) : Collections.emptyList();
            result.put((ShowcaseManager.ShareType)((Object)type), (List<String>)keywords);
        });
        return result;
    }

    static {
        PLACEHOLDER_CACHE = new EnumMap<ShowcaseManager.ShareType, String>(ShowcaseManager.ShareType.class);
        TYPE_TO_IDENTIFIER = Map.of(ShowcaseManager.ShareType.ITEM, Placeholders.ITEM, ShowcaseManager.ShareType.INVENTORY, Placeholders.INVENTORY, ShowcaseManager.ShareType.HOTBAR, Placeholders.HOTBAR, ShowcaseManager.ShareType.ENDER_CHEST, Placeholders.ENDER_CHEST, ShowcaseManager.ShareType.STATS, Placeholders.STATS);
        TYPE_TO_IDENTIFIER.forEach((type, id) -> PLACEHOLDER_CACHE.put((ShowcaseManager.ShareType)((Object)type), "%" + id.method_12836() + ":" + id.method_12832() + "%"));
        SUPPORTED_PLACEHOLDERS = Set.copyOf(PLACEHOLDER_CACHE.values());
    }
}

