/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.placeholders;

import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfigManager;
import com.showcase.placeholders.ShowcaseStatistics;
import com.showcase.utils.permissions.PermissionChecker;
import com.showcase.utils.permissions.Permissions;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ExtendedPlaceholders {
    private static final AtomicInteger totalSharesCreated = new AtomicInteger(0);

    public static void registerExtendedPlaceholders() {
        if (!ModConfigManager.isPlaceholderExtensionsEnabled()) {
            return;
        }
        ExtendedPlaceholders.registerPlayerSharePlaceholders();
        ExtendedPlaceholders.registerPermissionPlaceholders();
    }

    private static void registerPlayerSharePlaceholders() {
        Placeholders.register((class_2960)ExtendedPlaceholders.id("shares_count"), (ctx, arg) -> {
            class_3222 player = ctx.player();
            if (player == null) {
                return PlaceholderResult.invalid((String)"No player context");
            }
            int count = ShowcaseStatistics.getActiveShareCount(player);
            return PlaceholderResult.value((class_2561)class_2561.method_43470((String)String.valueOf(count)));
        });
        Placeholders.register((class_2960)ExtendedPlaceholders.id("total_views"), (ctx, arg) -> {
            class_3222 player = ctx.player();
            if (player == null) {
                return PlaceholderResult.invalid((String)"No player context");
            }
            long views = ShowcaseStatistics.getTotalViewsForPlayer(player);
            return PlaceholderResult.value((class_2561)class_2561.method_43470((String)String.valueOf(views)));
        });
    }

    private static void registerPermissionPlaceholders() {
        Placeholders.register((class_2960)ExtendedPlaceholders.id("can_share_item"), (ctx, arg) -> {
            class_3222 player = ctx.player();
            if (player == null) {
                return PlaceholderResult.invalid((String)"No player context");
            }
            boolean canShare = PermissionChecker.hasPermission(player, Permissions.Command.ITEM, 0);
            return PlaceholderResult.value((class_2561)class_2561.method_43470((String)String.valueOf(canShare)));
        });
        Placeholders.register((class_2960)ExtendedPlaceholders.id("has_admin_perms"), (ctx, arg) -> {
            class_3222 player = ctx.player();
            if (player == null) {
                return PlaceholderResult.invalid((String)"No player context");
            }
            boolean isAdmin = PermissionChecker.hasPermission(player, Permissions.Manage.CANCEL, 0);
            return PlaceholderResult.value((class_2561)class_2561.method_43470((String)String.valueOf(isAdmin)));
        });
    }

    private static class_2960 id(String path) {
        return class_2960.method_60655((String)"showcase", (String)path);
    }

    public static void incrementTotalShares() {
        totalSharesCreated.incrementAndGet();
    }

    public static void incrementShareTypeStats(ShowcaseManager.ShareType type) {
    }

    public static void incrementPlayerShares(String playerUuid) {
    }
}

