/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.placeholders;

import com.showcase.command.ShareCommandUtils;
import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfig;
import com.showcase.config.ModConfigManager;
import com.showcase.placeholders.ExtendedPlaceholders;
import com.showcase.utils.ShareConstants;
import com.showcase.utils.StackUtils;
import com.showcase.utils.TextUtils;
import com.showcase.utils.permissions.PermissionChecker;
import com.showcase.utils.permissions.Permissions;
import com.showcase.utils.stats.StatUtils;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.arguments.SimpleArguments;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.function.Function;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class Placeholders {
    public static final class_2960 INVENTORY = ShareConstants.PlaceholderIds.INVENTORY;
    public static final class_2960 HOTBAR = ShareConstants.PlaceholderIds.HOTBAR;
    public static final class_2960 ITEM = ShareConstants.PlaceholderIds.ITEM;
    public static final class_2960 ENDER_CHEST = ShareConstants.PlaceholderIds.ENDER_CHEST;
    public static final class_2960 STATS = ShareConstants.PlaceholderIds.STATS;
    private static final String NO_PERMISSION = "You don't have permission to use this placeholder!";
    private static final String ON_COOLDOWN = "You have reached the usage limit. Please try again later.";
    private static final String INVALID_DURATION = "Invalid valid duration";
    private static final String NO_PLAYER = "No valid player";

    private static void registerPlaceholder(class_2960 identifier, ShowcaseManager.ShareType shareType, String permission, Function<ShareData, class_5250> shareCreator) {
        eu.pb4.placeholders.api.Placeholders.register((class_2960)identifier, (ctx, arg) -> {
            try {
                PlaceholderResult validation = Placeholders.validatePlaceholderRequest(ctx, arg, shareType, permission);
                if (validation != null) {
                    return validation;
                }
                class_3222 player = ctx.player();
                int duration = Placeholders.getDurationFromSimpleArguments(arg, player);
                class_5250 result = (class_5250)shareCreator.apply(new ShareData(player, duration));
                ShowcaseManager.setCooldown(player, shareType);
                return PlaceholderResult.value((class_2561)result);
            }
            catch (Exception e) {
                return PlaceholderResult.invalid((String)e.getMessage());
            }
        });
    }

    private static PlaceholderResult validatePlaceholderRequest(PlaceholderContext ctx, String arg, ShowcaseManager.ShareType shareType, String permission) {
        class_3222 player = ctx.player();
        if (player == null) {
            return PlaceholderResult.invalid((String)NO_PLAYER);
        }
        int duration = Placeholders.getDurationFromSimpleArguments(arg, player);
        ModConfig.ShareSettings settings = ModConfigManager.getShareSettings(shareType);
        if (settings == null || !PermissionChecker.hasPermission(player, permission, settings.defaultPermission)) {
            return PlaceholderResult.invalid((String)NO_PERMISSION);
        }
        if (ShowcaseManager.isOnCooldown(player, shareType)) {
            return PlaceholderResult.invalid((String)ON_COOLDOWN);
        }
        return null;
    }

    public static void registerPlaceholders() {
        Placeholders.registerPlaceholder(INVENTORY, ShowcaseManager.ShareType.INVENTORY, Permissions.Chat.Placeholder.INVENTORY, shareData -> ShareCommandUtils.createClickableItemName(ShowcaseManager.ShareType.INVENTORY, TextUtils.INVENTORY, ShowcaseManager.createInventoryShare(shareData.player, shareData.duration, null)));
        Placeholders.registerPlaceholder(HOTBAR, ShowcaseManager.ShareType.HOTBAR, Permissions.Chat.Placeholder.HOTBAR, shareData -> ShareCommandUtils.createClickableItemName(ShowcaseManager.ShareType.HOTBAR, TextUtils.HOTBAR, ShowcaseManager.createHotbarShare(shareData.player, shareData.duration, null)));
        Placeholders.registerPlaceholder(ENDER_CHEST, ShowcaseManager.ShareType.ENDER_CHEST, Permissions.Chat.Placeholder.ENDERCHEST, shareData -> ShareCommandUtils.createClickableItemName(ShowcaseManager.ShareType.ENDER_CHEST, TextUtils.ENDER_CHEST, ShowcaseManager.createEnderChestShare(shareData.player, shareData.duration, null)));
        Placeholders.registerPlaceholder(STATS, ShowcaseManager.ShareType.STATS, Permissions.Chat.Placeholder.STATS, shareData -> {
            class_1799 stack = StatUtils.createStatsBook(shareData.player);
            if (stack.method_7960()) {
                throw new RuntimeException("Statistics reading failed");
            }
            return ShareCommandUtils.createClickableItemName(ShowcaseManager.ShareType.STATS, StackUtils.getDisplayName(stack), ShowcaseManager.createStatsShare(shareData.player, stack, shareData.duration, null));
        });
        Placeholders.registerPlaceholder(ITEM, ShowcaseManager.ShareType.ITEM, Permissions.Chat.Placeholder.ITEM, shareData -> {
            class_1799 stack = shareData.player.method_6118(class_1304.field_6173);
            if (stack.method_7960()) {
                throw new RuntimeException(class_2561.method_43471((String)"showcase.message.no_item").getString());
            }
            return ShareCommandUtils.createClickableItemName(ShowcaseManager.ShareType.ITEM, StackUtils.getDisplayName(stack), ShowcaseManager.createItemShare(shareData.player, stack, shareData.duration, null));
        });
        ExtendedPlaceholders.registerExtendedPlaceholders();
    }

    public static boolean containsPlaceholders(String text) {
        TextNode[] nodes;
        for (TextNode node : nodes = eu.pb4.placeholders.api.Placeholders.DEFAULT_PLACEHOLDER_PARSER.parseNodes((TextNode)new LiteralNode(text))) {
            if (!node.isDynamic()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOnlyPlaceholders(String text, PlaceholderContext context) {
        TextNode[] nodes;
        TextNode[] textNodeArray = nodes = eu.pb4.placeholders.api.Placeholders.DEFAULT_PLACEHOLDER_PARSER.parseNodes((TextNode)new LiteralNode(text));
        int n = textNodeArray.length;
        int n2 = 0;
        while (true) {
            block7: {
                if (n2 >= n) {
                    return true;
                }
                TextNode node = textNodeArray[n2];
                if (node instanceof LiteralNode) {
                    LiteralNode literalNode = (LiteralNode)node;
                    try {
                        String string;
                        String value = string = literalNode.value();
                        if (!value.trim().isEmpty()) {
                            return false;
                        }
                        break block7;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                if (!node.isDynamic()) {
                    return false;
                }
            }
            ++n2;
        }
    }

    private static int getDurationFromSimpleArguments(String arg, class_3222 player) {
        int inputDuration = SimpleArguments.intNumber((String)arg, (int)ModConfigManager.getShareLinkDefaultExpiry());
        if (PermissionChecker.isOp(player)) {
            return inputDuration > 0 ? inputDuration : ModConfigManager.getShareLinkDefaultExpiry();
        }
        if (inputDuration <= 0) {
            return ModConfigManager.getShareLinkDefaultExpiry();
        }
        if (inputDuration < ModConfigManager.getShareLinkMinExpiry()) {
            return ModConfigManager.getShareLinkMinExpiry();
        }
        if (inputDuration > ModConfigManager.getShareLinkDefaultExpiry()) {
            return ModConfigManager.getShareLinkDefaultExpiry();
        }
        return inputDuration;
    }

    private record ShareData(class_3222 player, int duration) {
    }
}

