/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils;

import com.showcase.config.ModConfigManager;
import com.showcase.gui.MapViewerContext;
import com.showcase.gui.MapViewerGui;
import com.showcase.utils.StackUtils;
import com.showcase.utils.compat.CallbackCompat;
import com.showcase.utils.compat.ServerPlayerCompat;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.gui.GuiInterface;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public final class MapViewer {
    private static final String MAP_MARK = "isShowcaseMap";
    private static final Map<UUID, ViewingSession> viewingSessions = new ConcurrentHashMap<UUID, ViewingSession>();

    private static class_1269 getCheckResult(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 serverPlayer = (class_3222)player;
        return MapViewer.isPlayerViewingMap(serverPlayer) ? class_1269.field_5814 : class_1269.field_5811;
    }

    public static void open(class_3222 player, class_1799 map, int displaySeconds) {
        if (player == null || player.method_7325() || !StackUtils.isMap(map).booleanValue()) {
            return;
        }
        UUID playerId = player.method_5667();
        MapViewer.closeSession(player);
        class_1799 displayMap = map.method_7972();
        class_9279 customData = (class_9279)displayMap.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = customData.method_57461();
        nbt.method_10556(MAP_MARK, true);
        displayMap.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        MapViewerContext context = new MapViewerContext(player, displayMap, displaySeconds);
        context.setCloseCallback(() -> MapViewer.handleMapViewerClose(player, displayMap));
        MapViewerGui gui = new MapViewerGui(context, 0);
        gui.open();
        viewingSessions.put(playerId, new ViewingSession(displayMap, ServerPlayerCompat.getWorld(player).method_8503().method_3780() + displaySeconds * 20));
    }

    public static void viewMap(class_3222 player, class_1799 mapItem) {
        if (player != null && mapItem != null) {
            int mapViewDuration = ModConfigManager.getConfig().mapViewDuration;
            if (mapViewDuration == -1) {
                return;
            }
            MapViewer.open(player, mapItem, mapViewDuration);
        }
    }

    private static void handleMapViewerClose(class_3222 player, class_1799 mapItem) {
        UUID playerId = player.method_5667();
        viewingSessions.remove(playerId);
    }

    public static boolean isPlayerViewingMap(class_3222 player) {
        return viewingSessions.containsKey(player.method_5667());
    }

    public static void closeSession(class_3222 player) {
        if (player == null) {
            return;
        }
        GuiInterface currentGui = GuiHelpers.getCurrentGui((class_3222)player);
        if (currentGui instanceof MapViewerGui) {
            MapViewerGui viewerGui = (MapViewerGui)currentGui;
            viewerGui.close();
        } else {
            UUID playerId = player.method_5667();
            ViewingSession session = viewingSessions.get(playerId);
            if (session != null) {
                MapViewer.handleMapViewerClose(player, session.displayMap);
            }
        }
    }

    public static void restoreAll(MinecraftServer server) {
        for (UUID playerId : new ArrayList<UUID>(viewingSessions.keySet())) {
            class_3222 player = server.method_3760().method_14602(playerId);
            if (player == null) continue;
            MapViewer.closeSession(player);
        }
        viewingSessions.clear();
    }

    public static int getViewingPlayersCount() {
        return viewingSessions.size();
    }

    public static boolean extendViewingTime(class_3222 player, int additionalSeconds) {
        UUID playerId = player.method_5667();
        ViewingSession session = viewingSessions.get(playerId);
        if (session == null) {
            return false;
        }
        int currentTick = ServerPlayerCompat.getWorld(player).method_8503().method_3780();
        int newTick = currentTick + additionalSeconds * 20;
        viewingSessions.put(playerId, new ViewingSession(session.displayMap, newTick));
        return true;
    }

    public static int getRemainingViewingTime(class_3222 player) {
        ViewingSession session = viewingSessions.get(player.method_5667());
        if (session == null) {
            return 0;
        }
        int currentTick = ServerPlayerCompat.getWorld(player).method_8503().method_3780();
        return Math.max(0, (session.autoRestoreTick - currentTick) / 20);
    }

    static {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (viewingSessions.isEmpty()) {
                return;
            }
            int currentTick = server.method_3780();
            ArrayList<UUID> toRemove = new ArrayList<UUID>();
            for (Map.Entry<UUID, ViewingSession> entry : viewingSessions.entrySet()) {
                UUID playerId = entry.getKey();
                ViewingSession session = entry.getValue();
                class_3222 player = server.method_3760().method_14602(playerId);
                if (player != null && currentTick < session.autoRestoreTick) continue;
                MapViewer.closeSession(player);
                toRemove.add(playerId);
            }
            toRemove.forEach(viewingSessions::remove);
        });
        UseItemCallback.EVENT.register((player, world, hand) -> (class_1269)CallbackCompat.getUseItemCallbackResult(player, MapViewer.getCheckResult(player)));
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> MapViewer.getCheckResult(player));
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> MapViewer.getCheckResult(player));
    }

    private record ViewingSession(class_1799 displayMap, int autoRestoreTick) {
    }
}

