/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils;

import com.showcase.ShowcaseMod;
import com.showcase.config.ModConfigManager;
import com.showcase.utils.compat.ServerPlayerCompat;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2994;
import net.minecraft.class_3222;
import net.minecraft.class_3806;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class ResourcePackChecker {
    private static boolean hasWarned = false;

    public static void checkResourcePackConfiguration(MinecraftServer server) {
        if (!ModConfigManager.getConfig().itemIcons.enabled) {
            return;
        }
        if (hasWarned) {
            return;
        }
        if (!(server instanceof class_2994)) {
            ShowcaseMod.LOGGER.debug("Not a dedicated server, skipping resource pack check");
            return;
        }
        class_2994 dedicated = (class_2994)server;
        try {
            class_3806 props = dedicated.method_16705();
            if (props.field_39093.isEmpty()) {
                ResourcePackChecker.warnAboutMissingResourcePack();
                hasWarned = true;
                return;
            }
            String resourcePackUrl = ((MinecraftServer.class_7460)props.field_39093.get()).comp_784();
            String resourcePackSha1 = ((MinecraftServer.class_7460)props.field_39093.get()).comp_785();
            boolean requireResourcePack = ((MinecraftServer.class_7460)props.field_39093.get()).comp_786();
            if (resourcePackUrl == null || resourcePackUrl.trim().isEmpty()) {
                ResourcePackChecker.warnAboutMissingResourcePack();
                hasWarned = true;
            } else {
                ShowcaseMod.LOGGER.info("Resource pack detected: {}", (Object)resourcePackUrl);
                if (resourcePackSha1 == null || resourcePackSha1.trim().isEmpty()) {
                    ShowcaseMod.LOGGER.warn("Resource pack URL is set but SHA1 hash is missing. Consider adding resource-pack-sha1 for better security");
                }
                if (!requireResourcePack) {
                    ShowcaseMod.LOGGER.warn("Resource pack is configured but not required. Consider setting require-resource-pack=true for better icon display experience");
                }
            }
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Failed to check resource pack configuration: {}", (Object)e.getMessage());
        }
    }

    private static void warnAboutMissingResourcePack() {
        ShowcaseMod.LOGGER.warn("=".repeat(60));
        ShowcaseMod.LOGGER.warn("SHOWCASE ICON FEATURE WARNING");
        ShowcaseMod.LOGGER.warn("=".repeat(60));
        ShowcaseMod.LOGGER.warn("Item icons are enabled but no resource pack is configured in server.properties!");
        ShowcaseMod.LOGGER.warn("Players will see translation keys instead of actual icons.");
        ShowcaseMod.LOGGER.warn("");
        ShowcaseMod.LOGGER.warn("To fix this, add the following lines to your server.properties:");
        ShowcaseMod.LOGGER.warn("  resource-pack=<your-resource-pack-url>");
        ShowcaseMod.LOGGER.warn("  resource-pack-sha1=<resource-pack-sha1-hash>");
        ShowcaseMod.LOGGER.warn("  require-resource-pack=true");
        ShowcaseMod.LOGGER.warn("");
        ShowcaseMod.LOGGER.warn("Alternatively, disable icon feature in config:");
        ShowcaseMod.LOGGER.warn("  itemIcons.enabled = false");
        ShowcaseMod.LOGGER.warn("=".repeat(60));
    }

    public static void sendResourcePackWarningToPlayer(class_3222 player) {
        if (!ModConfigManager.getConfig().itemIcons.enabled) {
            return;
        }
        if (!player.method_64475(2)) {
            return;
        }
        MinecraftServer server = ServerPlayerCompat.getServer(player);
        if (server instanceof class_2994) {
            String resourcePackUrl;
            class_2994 dedicated = (class_2994)server;
            if (dedicated.method_16705().field_39093.isPresent() && ((resourcePackUrl = ((MinecraftServer.class_7460)dedicated.method_16705().field_39093.get()).comp_784()) == null || resourcePackUrl.trim().isEmpty())) {
                class_5250 warningMessage = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("[" + "showcase".toUpperCase() + "] ")).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Warning: Item icons are enabled but no resource pack is configured! ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Players will see translation keys instead of icons. ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"Check server console for setup instructions.").method_27692(class_124.field_1080));
                player.method_7353((class_2561)warningMessage, false);
            }
        }
    }

    public static void reset() {
        hasWarned = false;
    }
}

