/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    private static final Pattern TIME_PATTERN = Pattern.compile("^(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s?)?$", 2);

    public static int parseTimeToSeconds(String timeString) {
        if (timeString == null || timeString.trim().isEmpty()) {
            throw new IllegalArgumentException("Time string cannot be null or empty");
        }
        timeString = timeString.trim().toLowerCase();
        try {
            return Integer.parseInt(timeString);
        }
        catch (NumberFormatException numberFormatException) {
            String seconds;
            String minutes;
            Matcher matcher = TIME_PATTERN.matcher(timeString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid time format: " + timeString + ". Use format like '1h', '30m', '1h30m', or plain seconds");
            }
            long totalSeconds = 0L;
            String hours = matcher.group(1);
            if (hours != null) {
                long h = Long.parseLong(hours);
                if (h > 8760L) {
                    throw new IllegalArgumentException("Hours value too large: " + h);
                }
                totalSeconds += h * 3600L;
            }
            if ((minutes = matcher.group(2)) != null) {
                long m = Long.parseLong(minutes);
                if (m > 525600L) {
                    throw new IllegalArgumentException("Minutes value too large: " + m);
                }
                totalSeconds += m * 60L;
            }
            if ((seconds = matcher.group(3)) != null) {
                totalSeconds += Long.parseLong(seconds);
            }
            if (totalSeconds <= 0L) {
                throw new IllegalArgumentException("Duration must be greater than 0");
            }
            if (totalSeconds > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Duration too large: " + totalSeconds + " seconds");
            }
            return (int)totalSeconds;
        }
    }

    public static String formatTime(int seconds) {
        if (seconds <= 0) {
            return "0s";
        }
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        int remainingSeconds = seconds % 60;
        StringBuilder result = new StringBuilder();
        if (hours > 0) {
            result.append(hours).append("h");
        }
        if (minutes > 0) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(minutes).append("m");
        }
        if (remainingSeconds > 0 || result.length() == 0) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(remainingSeconds).append("s");
        }
        return result.toString();
    }

    public static String formatDurationShort(int seconds) {
        if (seconds <= 0) {
            return "0s";
        }
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        int remainingSeconds = seconds % 60;
        StringBuilder result = new StringBuilder();
        if (hours > 0) {
            result.append(hours).append("h");
        }
        if (minutes > 0) {
            result.append(minutes).append("m");
        }
        if (remainingSeconds > 0 || hours == 0 && minutes == 0) {
            result.append(remainingSeconds).append("s");
        }
        return result.toString();
    }

    public static String formatSeconds(int seconds) {
        return TimeUtils.formatTime(seconds);
    }
}

