/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils.minecraft;

import com.showcase.utils.minecraft.BlockCategoryMatcher;
import com.showcase.utils.minecraft.BlockCategoryRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public final class BlockCategoryCache {
    private static final AtomicReference<Map<class_5321<class_1761>, Set<class_1792>>> CACHE_REF = new AtomicReference();

    private BlockCategoryCache() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static Map<class_5321<class_1761>, Set<class_1792>> getCache() {
        return CACHE_REF.updateAndGet(cache -> cache != null ? cache : BlockCategoryCache.initializeCache());
    }

    public static class_5321<class_1761> getCachedCategory(class_1792 item) {
        Map<class_5321<class_1761>, Set<class_1792>> cache = BlockCategoryCache.getCache();
        return cache.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(item)).map(Map.Entry::getKey).findFirst().orElse(class_7706.field_40195);
    }

    public static void clearCache() {
        CACHE_REF.set(null);
    }

    private static Map<class_5321<class_1761>, Set<class_1792>> initializeCache() {
        HashMap cache = new HashMap();
        BlockCategoryRegistry.getAllCategories().forEach(category -> cache.put(category, ConcurrentHashMap.newKeySet()));
        for (class_2248 block : class_7923.field_41175) {
            class_1792 item = block.method_8389();
            if (item == null) continue;
            String itemName = class_7923.field_41178.method_10221((Object)item).method_12832();
            class_5321<class_1761> category2 = BlockCategoryMatcher.categorizeByName(itemName);
            ((Set)cache.get(category2)).add(item);
        }
        return Map.copyOf(cache);
    }
}

