/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils.permissions;

import com.showcase.command.ShowcaseManager;

public final class Permissions {
    public static final String ADMIN = "admin";
    public static final String COMMAND = "command";
    public static final String MANAGE = "manage";
    public static final String CHAT = "chat";

    public static CommandType getCommandTypeFromShareType(ShowcaseManager.ShareType shareType) {
        return switch (shareType) {
            default -> throw new MatchException(null, null);
            case ShowcaseManager.ShareType.ITEM -> CommandType.ITEM;
            case ShowcaseManager.ShareType.INVENTORY -> CommandType.INVENTORY;
            case ShowcaseManager.ShareType.HOTBAR -> CommandType.HOTBAR;
            case ShowcaseManager.ShareType.ENDER_CHEST -> CommandType.ENDERCHEST;
            case ShowcaseManager.ShareType.STATS -> CommandType.STATS;
            case ShowcaseManager.ShareType.CONTAINER -> CommandType.CONTAINER;
            case ShowcaseManager.ShareType.MERCHANT -> CommandType.MERCHANT;
        };
    }

    public static String node(String ... parts) {
        return String.join((CharSequence)".", parts);
    }

    private Permissions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum CommandType {
        VIEW("view".toLowerCase()),
        CANCEL("cancel".toLowerCase()),
        ITEM("item".toLowerCase()),
        INVENTORY("inventory".toLowerCase()),
        HOTBAR("hotbar".toLowerCase()),
        ENDERCHEST("ender_chest".toLowerCase()),
        CONTAINER("container".toLowerCase()),
        MERCHANT("merchant".toLowerCase()),
        STATS("stats".toLowerCase());

        private final String permission;

        private CommandType(String command) {
            this.permission = Permissions.node(Permissions.COMMAND, command);
        }

        public String getPermission() {
            return this.permission;
        }

        public String getCooldown() {
            return Permissions.node(this.permission, "cooldown");
        }

        public String receivers() {
            return Permissions.node(this.permission, "receivers");
        }

        public String duration() {
            return Permissions.node(this.permission, "duration");
        }

        public String description() {
            return Permissions.node(this.permission, "description");
        }

        public String toString() {
            return this.permission;
        }
    }

    public static final class Chat {
        public static final String PLACEHOLDER = Permissions.node("chat", "placeholder");

        private Chat() {
        }

        public static final class Placeholder {
            public static final String INVENTORY = Permissions.node("chat", "placeholder", "inventory".toLowerCase());
            public static final String HOTBAR = Permissions.node("chat", "placeholder", "hotbar".toLowerCase());
            public static final String ENDERCHEST = Permissions.node("chat", "placeholder", "ender_chest".toLowerCase());
            public static final String STATS = Permissions.node("chat", "placeholder", "stats".toLowerCase());
            public static final String ITEM = Permissions.node("chat", "placeholder", "item".toLowerCase());

            private Placeholder() {
            }
        }
    }

    public static final class Manage {
        public static final String ABOUT = Permissions.node("manage", "about");
        public static final String RELOAD = Permissions.node("manage", "reload");
        public static final String LIST = Permissions.node("manage", "list");
        public static final String CANCEL = Permissions.node("manage", "cancel");

        private Manage() {
        }
    }

    public static final class Command {
        public static final String VIEW = CommandType.VIEW.getPermission();
        public static final String ITEM = CommandType.ITEM.getPermission();
        public static final String INVENTORY = CommandType.INVENTORY.getPermission();
        public static final String HOTBAR = CommandType.HOTBAR.getPermission();
        public static final String ENDERCHEST = CommandType.ENDERCHEST.getPermission();
        public static final String CONTAINER = CommandType.CONTAINER.getPermission();
        public static final String MERCHANT = CommandType.MERCHANT.getPermission();
        public static final String STATS = CommandType.STATS.getPermission();
        public static final String CANCEL = CommandType.CANCEL.getPermission();

        private Command() {
        }
    }
}

