/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils.ui;

import com.showcase.utils.TextEventFactory;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ChatPaginator<T> {
    private final List<T> items;
    private final int pageSize;
    private final String commandPrefix;

    public ChatPaginator(List<T> items, int pageSize, String commandPrefix) {
        this.items = items != null ? items : Collections.emptyList();
        this.pageSize = pageSize;
        this.commandPrefix = commandPrefix;
    }

    public int getTotalPages() {
        return (int)Math.ceil((double)this.items.size() / (double)this.pageSize);
    }

    public int clampPage(int page) {
        return Math.max(1, Math.min(page, this.getTotalPages()));
    }

    public synchronized List<T> getPageItems(int page) {
        page = this.clampPage(page);
        int fromIndex = (page - 1) * this.pageSize;
        int toIndex = Math.min(page * this.pageSize, this.items.size());
        return this.items.subList(fromIndex, toIndex);
    }

    public class_5250 renderPage(int page, Function<T, class_2561> renderer, String title) {
        int totalPages = this.getTotalPages();
        page = this.clampPage(page);
        List<T> pageItems = this.getPageItems(page);
        class_5250 result = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(title + " Page " + page + "/" + totalPages + "\n")).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        for (T item : pageItems) {
            result.method_10852(renderer.apply(item));
        }
        if (totalPages > 1) {
            result.method_10852((class_2561)this.buildNavLine(page, totalPages));
        }
        return result;
    }

    private class_5250 buildNavLine(int page, int totalPages) {
        class_5250 nav = class_2561.method_43470((String)"\n");
        if (page > 1) {
            nav.method_10852((class_2561)class_2561.method_43471((String)"spectatorMenu.previous_page").method_27692(class_124.field_1078).method_27694(s -> s.method_10958(TextEventFactory.navigateToPage(this.commandPrefix, page - 1)).method_10949(TextEventFactory.previousPageTooltip())));
        }
        nav.method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1063));
        if (page < totalPages) {
            nav.method_10852((class_2561)class_2561.method_43471((String)"spectatorMenu.next_page").method_27692(class_124.field_1078).method_27694(s -> s.method_10958(TextEventFactory.navigateToPage(this.commandPrefix, page + 1)).method_10949(TextEventFactory.nextPageTooltip())));
        }
        return nav;
    }
}

