/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils.ui;

import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfigManager;
import com.showcase.data.ShareEntry;
import com.showcase.utils.ReadOnlyInventory;
import com.showcase.utils.compat.StyleCompat;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public class ItemIconProvider {
    private static final String ITEM_MINECRAFT_PREFIX = "item.minecraft.";
    private static final String BLOCK_MINECRAFT_PREFIX = "block.minecraft.";
    private static final String MINECRAFT_ITEM_PATH = "minecraft.item.";
    private static final String MINECRAFT_BLOCK_PATH = "minecraft.block.";
    private static final String FONT_NAME = "default";
    private static final String ENDER_CHEST_NAME = "ender_chest";

    public static class_5250 getIconForItem(class_1799 itemStack) {
        if (!ItemIconProvider.isEnabled() || !ItemIconProvider.shouldIncludeInItemNames() || itemStack == null || itemStack.method_7960()) {
            return class_2561.method_43473();
        }
        String itemTranslationKey = itemStack.method_7909().method_7876();
        if (itemTranslationKey.startsWith(ITEM_MINECRAFT_PREFIX)) {
            String itemName = itemTranslationKey.substring(ITEM_MINECRAFT_PREFIX.length());
            return ItemIconProvider.createItemIcon(itemName);
        }
        if (itemTranslationKey.startsWith(BLOCK_MINECRAFT_PREFIX)) {
            String itemName = itemTranslationKey.substring(BLOCK_MINECRAFT_PREFIX.length());
            return ItemIconProvider.createBlockIcon(itemName);
        }
        return class_2561.method_43473();
    }

    public static class_5250 getIconForShareTypeWithId(ShowcaseManager.ShareType shareType, String shareId) {
        if (!ItemIconProvider.isEnabled()) {
            return class_2561.method_43473();
        }
        return switch (shareType) {
            case ShowcaseManager.ShareType.ITEM, ShowcaseManager.ShareType.STATS -> {
                class_1799 stack = ShowcaseManager.getItemStackWithID(shareId);
                yield ItemIconProvider.getIconForItem(stack);
            }
            case ShowcaseManager.ShareType.ENDER_CHEST -> ItemIconProvider.createBlockIcon(ENDER_CHEST_NAME);
            case ShowcaseManager.ShareType.CONTAINER -> ItemIconProvider.getIconForContainer(shareId);
            default -> class_2561.method_43473();
        };
    }

    private static class_5250 createItemIcon(String itemName) {
        return ItemIconProvider.createIconText(MINECRAFT_ITEM_PATH + itemName);
    }

    private static class_5250 createBlockIcon(String blockName) {
        class_5250 blockIcon = ItemIconProvider.createIconText(MINECRAFT_BLOCK_PATH + blockName + (blockName.contains("shulker_box") ? "" : "_top"));
        return blockIcon;
    }

    private static class_5250 createIconText(String iconPath) {
        String fontNamespace = ItemIconProvider.getFontNamespace();
        class_2960 fontId = class_2960.method_60655((String)fontNamespace, (String)FONT_NAME);
        String fullIconKey = fontNamespace + "." + iconPath;
        return class_2561.method_43471((String)fullIconKey).method_10862(StyleCompat.withFont(class_2583.field_24360, fontId).method_10977(class_124.field_1068).method_30938(Boolean.valueOf(false)));
    }

    private static boolean isEnabled() {
        return ModConfigManager.getConfig().itemIcons.enabled;
    }

    private static boolean shouldIncludeInItemNames() {
        return ModConfigManager.getConfig().itemIcons.includeInItemNames;
    }

    private static String getFontNamespace() {
        return ModConfigManager.getConfig().itemIcons.fontNamespace;
    }

    private static class_5250 getIconForContainer(String shareId) {
        class_2588 translatable;
        String key;
        ShareEntry shareEntry = ShowcaseManager.getShareEntry(shareId);
        if (shareEntry == null || shareEntry.getType() != ShowcaseManager.ShareType.CONTAINER) {
            return class_2561.method_43473();
        }
        ReadOnlyInventory inventory = shareEntry.getInventory();
        if (inventory == null) {
            return class_2561.method_43473();
        }
        class_2561 name = inventory.getName();
        if (name == null) {
            return class_2561.method_43473();
        }
        class_7417 content = name.method_10851();
        if (content instanceof class_2588 && (key = (translatable = (class_2588)content).method_11022()).contains(".")) {
            String containerName = key.substring(key.lastIndexOf(".") + 1);
            return ItemIconProvider.createBlockIcon(containerName);
        }
        return class_2561.method_43473();
    }
}

