/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils.ui;

import com.showcase.config.ModConfigManager;
import com.showcase.utils.compat.TextEventCompat;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public final class TextBuilder {
    private static final class_2583 ERROR_STYLE = class_2583.field_24360.method_10977(class_124.field_1061);
    private static final class_2583 WARNING_STYLE = class_2583.field_24360.method_10977(class_124.field_1054);
    private static final class_2583 SUCCESS_STYLE = class_2583.field_24360.method_10977(class_124.field_1060);
    private static final class_2583 INFO_STYLE = class_2583.field_24360.method_10977(class_124.field_1075);
    private static final class_2583 HIGHLIGHT_STYLE = class_2583.field_24360.method_10977(class_124.field_1065);

    private TextBuilder() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static class_5250 error(class_2561 text) {
        return text.method_27661().method_10862(ERROR_STYLE);
    }

    public static class_5250 error(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args).method_10862(ERROR_STYLE);
    }

    public static class_5250 warning(class_2561 text) {
        return text.method_27661().method_10862(WARNING_STYLE);
    }

    public static class_5250 warning(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args).method_10862(WARNING_STYLE);
    }

    public static class_5250 success(class_2561 text) {
        return text.method_27661().method_10862(SUCCESS_STYLE);
    }

    public static class_5250 success(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args).method_10862(SUCCESS_STYLE);
    }

    public static class_5250 info(class_2561 text) {
        return text.method_27661().method_10862(INFO_STYLE);
    }

    public static class_2568 showItem(class_1799 itemStack) {
        return TextEventCompat.showItem(itemStack);
    }

    public static class_5250 info(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args).method_10862(INFO_STYLE);
    }

    public static class_5250 highlight(class_2561 text) {
        return text.method_27661().method_10862(HIGHLIGHT_STYLE);
    }

    public static class_5250 highlight(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args).method_10862(HIGHLIGHT_STYLE);
    }

    public static class_5250 clickable(class_2561 text, class_2558 clickEvent) {
        return text.method_27661().method_27694(style -> style.method_10958(clickEvent));
    }

    public static class_5250 clickableWithConfig(class_2561 text, class_2558 clickEvent, boolean applyUnderline) {
        return text.method_27661().method_27694(style -> {
            class_2583 newStyle = style.method_10958(clickEvent);
            if (applyUnderline && ModConfigManager.getConfig().shareLink.enableClickableTextUnderline) {
                newStyle = newStyle.method_30938(Boolean.valueOf(true));
            }
            return newStyle;
        });
    }

    public static class_5250 clickableWithConfig(class_2561 text, class_2558 clickEvent) {
        return TextBuilder.clickableWithConfig(text, clickEvent, true);
    }

    public static class_5250 interactive(class_2561 text, class_2558 clickEvent, class_2568 hoverEvent) {
        return text.method_27661().method_27694(style -> style.method_10958(clickEvent).method_10949(hoverEvent));
    }

    public static class_5250 interactiveWithConfig(class_2561 text, class_2558 clickEvent, class_2568 hoverEvent, boolean applyUnderline) {
        return text.method_27661().method_27694(style -> {
            class_2583 newStyle = style.method_10958(clickEvent).method_10949(hoverEvent);
            if (applyUnderline && ModConfigManager.getConfig().shareLink.enableClickableTextUnderline) {
                newStyle = newStyle.method_30938(Boolean.valueOf(true));
            }
            return newStyle;
        });
    }

    public static class_5250 interactiveWithConfig(class_2561 text, class_2558 clickEvent, class_2568 hoverEvent) {
        return TextBuilder.interactiveWithConfig(text, clickEvent, hoverEvent, true);
    }

    public static class_5250 runCommand(class_2561 text, String command) {
        return TextBuilder.clickable(text, TextEventCompat.runCommand("/" + command));
    }

    public static class_5250 suggestCommand(class_2561 text, String command) {
        return TextBuilder.clickable(text, TextEventCompat.suggestCommand("/" + command));
    }

    public static class_5250 url(class_2561 text, String url) {
        return TextBuilder.clickable(text, TextEventCompat.openUrl(url));
    }

    public static class_5250 withTooltip(class_2561 text, class_2561 tooltip) {
        return text.method_27661().method_27694(style -> style.method_10949(TextEventCompat.showText(tooltip)));
    }

    public static TextComponentBuilder build(class_2561 text) {
        return new TextComponentBuilder(text.method_27661());
    }

    public static TextComponentBuilder build(String key, Object ... args) {
        return new TextComponentBuilder(class_2561.method_43469((String)key, (Object[])args));
    }

    public static class TextComponentBuilder {
        private final class_5250 text;

        private TextComponentBuilder(class_5250 text) {
            this.text = text;
        }

        public TextComponentBuilder style(class_124 ... formatting) {
            this.text.method_27695(formatting);
            return this;
        }

        public TextComponentBuilder color(class_124 color) {
            this.text.method_27694(style -> style.method_10977(color));
            return this;
        }

        public TextComponentBuilder click(class_2558 clickEvent) {
            this.text.method_27694(style -> style.method_10958(clickEvent));
            return this;
        }

        public TextComponentBuilder clickWithConfig(class_2558 clickEvent) {
            return this.clickWithConfig(clickEvent, true);
        }

        public TextComponentBuilder clickWithConfig(class_2558 clickEvent, boolean applyUnderline) {
            this.text.method_27694(style -> {
                class_2583 newStyle = style.method_10958(clickEvent);
                if (applyUnderline && ModConfigManager.getConfig().shareLink.enableClickableTextUnderline) {
                    newStyle = newStyle.method_30938(Boolean.valueOf(true));
                }
                return newStyle;
            });
            return this;
        }

        public TextComponentBuilder hover(class_2568 hoverEvent) {
            this.text.method_27694(style -> style.method_10949(hoverEvent));
            return this;
        }

        public TextComponentBuilder runCommand(String command) {
            return this.click(TextEventCompat.runCommand("/" + command));
        }

        public TextComponentBuilder suggestCommand(String command) {
            return this.click(TextEventCompat.suggestCommand("/" + command));
        }

        public TextComponentBuilder url(String url) {
            return this.click(TextEventCompat.openUrl(url));
        }

        public TextComponentBuilder tooltip(class_2561 tooltip) {
            return this.hover(TextEventCompat.showText(tooltip));
        }

        public TextComponentBuilder append(class_2561 other) {
            this.text.method_10852(other);
            return this;
        }

        public class_5250 build() {
            return this.text;
        }
    }
}

