/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.api;

import com.showcase.api.ShowcaseManagerWrapper;
import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfig;
import com.showcase.config.ModConfigManager;
import com.showcase.data.ShareEntry;
import com.showcase.event.ShowcaseCreatedCallback;
import com.showcase.event.ShowcaseEvents;
import com.showcase.event.ShowcaseViewedCallback;
import com.showcase.utils.ModMetadataHolder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class ShowcaseAPI {
    private static final ShowcaseAPI INSTANCE = new ShowcaseAPI();

    private ShowcaseAPI() {
    }

    @NotNull
    public static ShowcaseAPI getInstance() {
        return INSTANCE;
    }

    @NotNull
    public ShowcaseManagerWrapper getShowcaseManager() {
        return new ShowcaseManagerWrapper();
    }

    @NotNull
    public ModConfig getConfig() {
        return ModConfigManager.getConfig();
    }

    @Nullable
    public ShareEntry getShareEntry(@NotNull String shareId) {
        return ShowcaseManager.getShareEntry(shareId);
    }

    @NotNull
    public Map<String, ShareEntry> getAllActiveShares() {
        return ShowcaseManager.getAllActiveShares();
    }

    @NotNull
    public List<ShareEntry> getPlayerShares(@NotNull String playerUuid) {
        return ShowcaseManager.getPlayerShares(playerUuid);
    }

    public boolean cancelShare(@NotNull String shareId) {
        return ShowcaseManager.cancelShare(shareId);
    }

    public boolean isValidShare(@NotNull String shareId) {
        ShareEntry entry = this.getShareEntry(shareId);
        if (entry == null) {
            return false;
        }
        long expiryTime = entry.getTimestamp() + (long)entry.getDuration() * 1000L;
        return System.currentTimeMillis() <= expiryTime;
    }

    public void onShowcaseCreated(@NotNull ShowcaseCreatedCallback listener) {
        ShowcaseEvents.SHOWCASE_CREATED.register((Object)listener);
    }

    public void onShowcaseViewed(@NotNull ShowcaseViewedCallback listener) {
        ShowcaseEvents.SHOWCASE_VIEWED.register((Object)listener);
    }

    @ApiStatus.Internal
    public static class_1269 fireShowcaseCreatedEvent(@NotNull ShowcaseManager.ShareType shareType, @NotNull ShareEntry shareEntry, @NotNull class_3222 sender, @NotNull class_3222 sourcePlayer, @Nullable Collection<class_3222> receivers, @NotNull String shareId, @Nullable String description, @Nullable Integer duration) {
        return ((ShowcaseCreatedCallback)ShowcaseEvents.SHOWCASE_CREATED.invoker()).onShowcaseCreated(sender, sourcePlayer, receivers, shareType, shareEntry, shareId, description, duration);
    }

    @ApiStatus.Internal
    public static class_1269 fireShowcaseViewedEvent(@NotNull class_3222 viewer, @NotNull ShareEntry shareEntry, @NotNull String shareId, @NotNull class_3222 originalOwner) {
        return ((ShowcaseViewedCallback)ShowcaseEvents.SHOWCASE_VIEWED.invoker()).onShowcaseViewed(viewer, shareEntry, shareId, originalOwner);
    }

    @NotNull
    public String getModVersion() {
        return ModMetadataHolder.VERSION;
    }
}

