/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.showcase.config.ModConfigManager;
import com.showcase.placeholders.PlaceholderTest;
import com.showcase.utils.permissions.PermissionChecker;
import com.showcase.utils.permissions.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PlaceholderTestCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"showcase-test").requires(source -> source.method_43737() && PermissionChecker.hasPermission(source.method_44023(), Permissions.Manage.CANCEL, 0))).then(class_2170.method_9247((String)"placeholders").executes(PlaceholderTestCommand::testPlaceholders))).then(class_2170.method_9247((String)"validation").executes(PlaceholderTestCommand::validatePlaceholders))).then(class_2170.method_9247((String)"performance").then(class_2170.method_9244((String)"iterations", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(PlaceholderTestCommand::testPerformance))));
    }

    private static int testPlaceholders(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        if (!ModConfigManager.isPlaceholderExtensionsEnabled()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7cPlaceholder extensions are disabled in config"));
            return 0;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76Starting placeholder test..."));
        PlaceholderTest.testEssentialPlaceholders(player);
        return 1;
    }

    private static int validatePlaceholders(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76Validating placeholder registration..."));
        boolean isValid = PlaceholderTest.validatePlaceholderRegistration();
        if (isValid) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7a\u2713 All essential placeholders are registered correctly"));
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c\u2717 Some placeholders are missing or not registered"));
        }
        return isValid ? 1 : 0;
    }

    private static int testPerformance(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        int iterations = IntegerArgumentType.getInteger(context, (String)"iterations");
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76Starting performance test..."));
        PlaceholderTest.testPlaceholderPerformance(player, iterations);
        return 1;
    }
}

