/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.command;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.showcase.api.ShowcaseAPI;
import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfigManager;
import com.showcase.data.ShareEntry;
import com.showcase.gui.MerchantContext;
import com.showcase.utils.PlayerUtils;
import com.showcase.utils.ReadOnlyInventory;
import com.showcase.utils.StackUtils;
import com.showcase.utils.TextEventFactory;
import com.showcase.utils.TextUtils;
import com.showcase.utils.compat.ServerPlayerCompat;
import com.showcase.utils.permissions.PermissionChecker;
import com.showcase.utils.permissions.Permissions;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class ShareCommandUtils {
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("MM/dd HH:mm:ss");

    public static Collection<class_3222> getReceivers(CommandContext<class_2168> ctx) {
        try {
            Collection receivers = class_2186.method_9312(ctx, (String)"receivers");
            if (receivers.isEmpty()) {
                return null;
            }
            if (ShareCommandUtils.isAtAll(ctx, receivers)) {
                return null;
            }
            return receivers;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean canSpecifyReceivers(class_3222 player, ShowcaseManager.ShareType shareType) {
        Permissions.CommandType commandType = Permissions.getCommandTypeFromShareType(shareType);
        return PermissionChecker.hasPermission(player, commandType.receivers(), 2);
    }

    public static boolean canSpecifyDuration(class_3222 player, ShowcaseManager.ShareType shareType) {
        Permissions.CommandType commandType = Permissions.getCommandTypeFromShareType(shareType);
        return PermissionChecker.hasPermission(player, commandType.duration(), 2);
    }

    public static boolean canSpecifyDescription(class_3222 player, ShowcaseManager.ShareType shareType) {
        Permissions.CommandType commandType = Permissions.getCommandTypeFromShareType(shareType);
        return PermissionChecker.hasPermission(player, commandType.description(), 1);
    }

    public static class_3222 getSenderPlayer(CommandContext<class_2168> ctx) {
        try {
            return ((class_2168)ctx.getSource()).method_9207();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class_3222 getSourcePlayer(CommandContext<class_2168> ctx) {
        try {
            return class_2186.method_9315(ctx, (String)"source");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class_3222 getSourceOrSender(CommandContext<class_2168> ctx) {
        class_3222 sourcePlayer = ShareCommandUtils.getSourcePlayer(ctx);
        if (sourcePlayer != null) {
            return sourcePlayer;
        }
        return ShareCommandUtils.getSenderPlayer(ctx);
    }

    public static String getDescription(CommandContext<class_2168> ctx) {
        try {
            return StringArgumentType.getString(ctx, (String)"description");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class_5250 createContainerPreview(ShareEntry shareEntry) {
        if (shareEntry == null) {
            return null;
        }
        ReadOnlyInventory inv = shareEntry.getInventory();
        HashMap<class_2561, Integer> counts = new HashMap<class_2561, Integer>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 s = inv.method_5438(i);
            if (s.method_7960() || StackUtils.isDivider(s)) continue;
            counts.merge(s.method_7964(), s.method_7947(), Integer::sum);
        }
        if (counts.isEmpty()) {
            return class_2561.method_43471((String)"item.minecraft.bundle.empty");
        }
        int maxLines = 5;
        class_5250 out = class_2561.method_43470((String)"");
        counts.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(maxLines).forEach(e -> out.method_10852((class_2561)e.getKey()).method_27693("\u00d7" + String.valueOf(e.getValue()) + "\n"));
        if (counts.size() > maxLines) {
            out.method_10852((class_2561)class_2561.method_43469((String)"showcase.preview_text.more", (Object[])new Object[]{counts.size() - maxLines})).method_27693("\n");
        }
        return out;
    }

    private static boolean isAtAll(CommandContext<class_2168> ctx, Collection<class_3222> receivers) {
        String input = ctx.getInput();
        int online = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571().size();
        return input.contains("@a") && receivers.size() == online;
    }

    private static class_5250 getFinalPreviewText(class_2561 itemName, ShowcaseManager.ShareType type, String shareId) {
        ShareEntry shareEntry = ShowcaseManager.getShareEntry(shareId);
        class_5250 sharePreview = shareEntry.getType() == ShowcaseManager.ShareType.MERCHANT ? ShareCommandUtils.createMerchantPreviewText(shareEntry.getMerchantContext()) : ShareCommandUtils.createContainerPreview(shareEntry);
        class_5250 preview = class_2561.method_43470((String)"").method_10852(itemName).method_27692(ShareCommandUtils.getFormattingColorForType(type, type == ShowcaseManager.ShareType.ITEM ? ShowcaseManager.getItemStackWithID(shareId) : null)).method_27693("\n");
        if (sharePreview != null) {
            preview.method_10852((class_2561)sharePreview).method_10852((class_2561)class_2561.method_43471((String)"showcase.message.click_to_view")).method_27693("\n\n").method_10852(TextUtils.BADGE).method_27692(class_124.field_1080);
        } else {
            preview.method_10852(TextUtils.EMPTY);
        }
        return preview;
    }

    private static class_5250 createMerchantPreviewText(MerchantContext merchantContext) {
        class_1916 offers;
        class_5250 preview = class_2561.method_43470((String)"");
        if (merchantContext.getExperience() > 0) {
            preview.method_10852((class_2561)class_2561.method_43469((String)"argument.entity.options.level.description", (Object[])new Object[]{merchantContext.getExperience()})).method_27692(class_124.field_1060).method_27693("\n");
        }
        if ((offers = merchantContext.getOffers()) != null && !offers.isEmpty()) {
            preview.method_10852((class_2561)class_2561.method_43469((String)"merchant.trades", (Object[])new Object[]{offers.size()})).method_27692(class_124.field_1075).method_27693("\n");
            int maxPreview = Math.min(5, offers.size());
            for (int i = 0; i < maxPreview; ++i) {
                class_1914 offer = (class_1914)offers.get(i);
                if (offer == null) continue;
                preview.method_27693("\u2022 ").method_10852(offer.method_8250().method_7964()).method_27692(class_124.field_1054);
                if (i >= maxPreview - 1) continue;
                preview.method_27693("\n");
            }
            if (offers.size() > maxPreview) {
                preview.method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"showcase.preview_text.more_trades", (Object[])new Object[]{offers.size() - maxPreview})).method_27692(class_124.field_1080).method_27693("\n");
            }
        }
        return preview;
    }

    public static class_5250 createClickableItemName(ShowcaseManager.ShareType type, class_2561 itemName, String shareId) {
        class_5250 hoverableName = ShareCommandUtils.createClickableTag(itemName, type, shareId);
        if (type == ShowcaseManager.ShareType.ITEM || type == ShowcaseManager.ShareType.STATS) {
            class_1799 stack = ShowcaseManager.getItemStackWithID(shareId);
            if (stack != null && !stack.method_7960()) {
                hoverableName.method_10862(hoverableName.method_10866().method_10949(TextEventFactory.showItem(stack)));
            }
            return hoverableName;
        }
        class_5250 preview = ShareCommandUtils.getFinalPreviewText(itemName, type, shareId);
        hoverableName.method_10862(hoverableName.method_10866().method_10949(TextEventFactory.showText((class_2561)preview)));
        return hoverableName;
    }

    public static void sendShareMessage(class_3222 sender, class_3222 sourcePlayer, Collection<class_3222> receivers, String description, ShowcaseManager.ShareType type, class_2561 itemName, Integer duration, String shareId) {
        ShareEntry shareEntry = ShowcaseManager.getShareEntry(shareId);
        if (shareEntry != null) {
            ShowcaseAPI.fireShowcaseCreatedEvent(type, shareEntry, sender, sourcePlayer, receivers, shareId, description, duration);
        }
        class_5250 clickableItemName = ShareCommandUtils.createClickableItemName(type, itemName, shareId);
        class_5250 message = ShareCommandUtils.buildShareMessage(sender, sourcePlayer, receivers, description, type, clickableItemName);
        class_5250 finalMessage = message.method_27693("\n").method_10852(TextUtils.info((class_2561)class_2561.method_43469((String)"showcase.message.expiry_notice", (Object[])new Object[]{(duration == null ? ModConfigManager.getShareLinkDefaultExpiry() : duration) / 60})));
        if (receivers != null) {
            for (class_3222 receiver : receivers) {
                receiver.method_43496((class_2561)message);
            }
            String receiverList = receivers.stream().map(class_1657::method_5476).filter(Objects::nonNull).map(class_2561::getString).collect(Collectors.joining(", "));
            sender.method_43496((class_2561)class_2561.method_43469((String)"showcase.message.private_share_tip", (Object[])new Object[]{sourcePlayer.method_5476(), clickableItemName, class_2561.method_43470((String)receiverList)}));
        } else {
            MinecraftServer server = ServerPlayerCompat.getServer(sender);
            if (server != null) {
                server.method_3760().method_43514((class_2561)finalMessage, false);
            }
        }
    }

    private static class_5250 buildShareMessage(class_3222 sender, class_3222 sourcePlayer, Collection<class_3222> receivers, String description, ShowcaseManager.ShareType type, class_5250 clickableItemName) {
        if (description != null) {
            return ShareCommandUtils.buildPlayerDescriptionMessage(sourcePlayer, description, clickableItemName);
        }
        boolean isPrivateMessage = receivers != null && sender.method_5667().equals(sourcePlayer.method_5667());
        return isPrivateMessage ? ShareCommandUtils.buildDefaultMessageForReceiver(sender, type, clickableItemName) : ShareCommandUtils.buildDefaultMessageForBroadcast(sender, sourcePlayer, type, clickableItemName);
    }

    public static class_5250 buildPlayerDescriptionMessage(class_3222 player, String description, class_5250 clickableItemName) {
        return class_2561.method_43469((String)"showcase.message.player_description", (Object[])new Object[]{PlayerUtils.getSafeDisplayName(player), description, clickableItemName});
    }

    public static class_2558 createShareClickEvent(String id) {
        return TextEventFactory.runFullCommand("/showcase-view " + id);
    }

    public static class_5250 buildDefaultMessageForReceiver(class_3222 sender, ShowcaseManager.ShareType type, class_5250 clickableItemName) {
        class_5250 senderPlayerDisplayName = PlayerUtils.getSafeDisplayName(sender);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ShowcaseManager.ShareType.ITEM -> class_2561.method_43469((String)"showcase.message.default.item", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
            case ShowcaseManager.ShareType.STATS -> class_2561.method_43469((String)"showcase.message.default.stats", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
            case ShowcaseManager.ShareType.INVENTORY -> class_2561.method_43469((String)"showcase.message.default.inventory", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
            case ShowcaseManager.ShareType.ENDER_CHEST -> class_2561.method_43469((String)"showcase.message.default.ender_chest", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
            case ShowcaseManager.ShareType.HOTBAR -> class_2561.method_43469((String)"showcase.message.default.hotbar", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
            case ShowcaseManager.ShareType.CONTAINER -> class_2561.method_43469((String)"showcase.message.default.container", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
            case ShowcaseManager.ShareType.MERCHANT -> class_2561.method_43469((String)"showcase.message.default.merchant", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
        };
    }

    public static class_5250 buildDefaultMessageForBroadcast(class_3222 sender, class_3222 sourcePlayer, ShowcaseManager.ShareType type, class_5250 clickableItemName) {
        boolean isSelf = sender.method_5667().equals(sourcePlayer.method_5667());
        class_5250 senderPlayerDisplayName = PlayerUtils.getSafeDisplayName(sender);
        class_5250 sourcePlayerDisplayName = PlayerUtils.getSafeDisplayName(sourcePlayer);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ShowcaseManager.ShareType.ITEM -> {
                if (isSelf) {
                    yield class_2561.method_43469((String)"showcase.message.item_shared", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
                }
                yield class_2561.method_43469((String)"showcase.message.other_item_shared", (Object[])new Object[]{senderPlayerDisplayName, sourcePlayerDisplayName, clickableItemName});
            }
            case ShowcaseManager.ShareType.STATS -> {
                if (isSelf) {
                    yield class_2561.method_43469((String)"showcase.message.stats_shared", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
                }
                yield class_2561.method_43469((String)"showcase.message.other_stats_shared", (Object[])new Object[]{senderPlayerDisplayName, sourcePlayerDisplayName, clickableItemName});
            }
            case ShowcaseManager.ShareType.CONTAINER -> {
                if (isSelf) {
                    yield class_2561.method_43469((String)"showcase.message.container_shared", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
                }
                yield class_2561.method_43469((String)"showcase.message.other_container_shared", (Object[])new Object[]{senderPlayerDisplayName, sourcePlayerDisplayName, clickableItemName});
            }
            case ShowcaseManager.ShareType.MERCHANT -> {
                if (isSelf) {
                    yield class_2561.method_43469((String)"showcase.message.merchant_shared", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
                }
                yield class_2561.method_43469((String)"showcase.message.other_merchant_shared", (Object[])new Object[]{senderPlayerDisplayName, sourcePlayerDisplayName, clickableItemName});
            }
            case ShowcaseManager.ShareType.INVENTORY -> {
                if (isSelf) {
                    yield class_2561.method_43469((String)"showcase.message.inventory_shared", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
                }
                yield class_2561.method_43469((String)"showcase.message.other_inventory_shared", (Object[])new Object[]{senderPlayerDisplayName, sourcePlayerDisplayName, clickableItemName});
            }
            case ShowcaseManager.ShareType.ENDER_CHEST -> {
                if (isSelf) {
                    yield class_2561.method_43469((String)"showcase.message.ender_chest_shared", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName});
                }
                yield class_2561.method_43469((String)"showcase.message.other_ender_chest_shared", (Object[])new Object[]{senderPlayerDisplayName, sourcePlayerDisplayName, clickableItemName});
            }
            case ShowcaseManager.ShareType.HOTBAR -> isSelf ? class_2561.method_43469((String)"showcase.message.hotbar_shared", (Object[])new Object[]{senderPlayerDisplayName, clickableItemName}) : class_2561.method_43469((String)"showcase.message.other_hotbar_shared", (Object[])new Object[]{senderPlayerDisplayName, sourcePlayerDisplayName, clickableItemName});
        };
    }

    public static class_124 getFormattingColorForType(ShowcaseManager.ShareType type, class_1799 itemStack) {
        if (itemStack != null && !itemStack.method_7960()) {
            if (ShareCommandUtils.isSpecialItem(itemStack)) {
                return class_124.field_1065;
            }
            return switch (itemStack.method_7932()) {
                default -> throw new MatchException(null, null);
                case class_1814.field_8906 -> class_124.field_1068;
                case class_1814.field_8907 -> class_124.field_1054;
                case class_1814.field_8903 -> class_124.field_1075;
                case class_1814.field_8904 -> class_124.field_1076;
            };
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ShowcaseManager.ShareType.ITEM -> class_124.field_1078;
            case ShowcaseManager.ShareType.STATS -> class_124.field_1062;
            case ShowcaseManager.ShareType.INVENTORY -> class_124.field_1060;
            case ShowcaseManager.ShareType.ENDER_CHEST -> class_124.field_1064;
            case ShowcaseManager.ShareType.HOTBAR -> class_124.field_1054;
            case ShowcaseManager.ShareType.CONTAINER, ShowcaseManager.ShareType.MERCHANT -> class_124.field_1065;
        };
    }

    private static boolean isSpecialItem(class_1799 itemStack) {
        return StackUtils.isMap(itemStack) != false || itemStack.method_31574(class_1802.field_8529) || itemStack.method_31574(class_1802.field_8674) || itemStack.method_31574(class_1802.field_8360) || itemStack.method_31574(class_1802.field_8598);
    }

    public static class_5250 createClickableTag(class_2561 name, ShowcaseManager.ShareType type, String id) {
        class_1799 stack = ShowcaseManager.getItemStackWithID(id);
        class_124 color = ShareCommandUtils.getFormattingColorForType(type, (class_1799)(type == ShowcaseManager.ShareType.ITEM ? stack : null));
        class_2561 displayName = type == ShowcaseManager.ShareType.ITEM || type == ShowcaseManager.ShareType.STATS ? name : class_2561.method_43470((String)"[").method_10852(name).method_27693("]");
        return class_2561.method_43470((String)"").method_10852(displayName).method_27694(style -> style.method_10977(color).method_30938(Boolean.valueOf(true)).method_10958(ShareCommandUtils.createShareClickEvent(id)));
    }

    public static class_5250 buildShareLine(class_3222 viewer, String shareId, ShareEntry share) {
        MinecraftServer server = ServerPlayerCompat.getServer(viewer);
        class_5250 ownerName = PlayerUtils.getSafeDisplayName(server, share.getOwnerUuid());
        class_2561 itemName = ShareCommandUtils.getShareItemName(share);
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\u25b6 ").method_27692(class_124.field_1063)).method_10852((class_2561)ShareCommandUtils.buildIdSection(shareId)).method_10852((class_2561)ShareCommandUtils.buildOwnerSection((class_2561)ownerName)).method_10852((class_2561)ShareCommandUtils.buildShareSection(share, itemName, shareId)).method_10852((class_2561)ShareCommandUtils.buildViewsSection(share.getViewCount())).method_10852((class_2561)ShareCommandUtils.buildTimeSection(share)).method_10852((class_2561)ShareCommandUtils.buildCancelSection(shareId)).method_10852((class_2561)class_2561.method_43470((String)"\n\n"));
    }

    private static class_5250 buildIdSection(String shareId) {
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"[ID] ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)shareId).method_27692(class_124.field_1054).method_27694(style -> style.method_10958(TextEventFactory.copyToClipboard(shareId)).method_10949(TextEventFactory.showText("Copy ID")))).method_10852((class_2561)class_2561.method_43470((String)"  "));
    }

    private static class_5250 buildOwnerSection(class_2561 ownerName) {
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"[Owner] ").method_27692(class_124.field_1080)).method_10852((class_2561)ownerName.method_27661().method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"  "));
    }

    private static class_5250 buildShareSection(ShareEntry share, class_2561 itemName, String shareId) {
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"[Share] ").method_27692(class_124.field_1080)).method_10852((class_2561)ShareCommandUtils.createClickableItemName(share.getType(), itemName, shareId)).method_10852((class_2561)class_2561.method_43470((String)"  "));
    }

    private static class_5250 buildViewsSection(int viewCount) {
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"[Views] ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(viewCount)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"  "));
    }

    private static class_5250 buildTimeSection(ShareEntry share) {
        long expiryTime = share.getTimestamp() + (long)share.getDuration() * 1000L;
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\n    ")).method_10852((class_2561)class_2561.method_43470((String)"Created: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)ShareCommandUtils.formatTime(share.getTimestamp())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" | Expires: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)ShareCommandUtils.formatTime(expiryTime)).method_27692(class_124.field_1068));
    }

    private static class_5250 buildCancelSection(String shareId) {
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" | [Cancel Share] ").method_27694(style -> style.method_10977(class_124.field_1061).method_10958(TextEventFactory.runFullCommand("/showcase-manage cancel " + shareId)).method_10949(TextEventFactory.cancelShareTooltip()))).method_10852((class_2561)class_2561.method_43470((String)"  "));
    }

    private static class_2561 getShareItemName(ShareEntry share) {
        return switch (share.getType()) {
            default -> throw new MatchException(null, null);
            case ShowcaseManager.ShareType.ITEM, ShowcaseManager.ShareType.STATS -> share.getInventory().getName();
            case ShowcaseManager.ShareType.INVENTORY -> TextUtils.INVENTORY;
            case ShowcaseManager.ShareType.HOTBAR -> TextUtils.HOTBAR;
            case ShowcaseManager.ShareType.ENDER_CHEST -> TextUtils.ENDER_CHEST;
            case ShowcaseManager.ShareType.MERCHANT -> {
                class_2561 name = share.getMerchantContext().getDisplayName();
                if (name != null) {
                    yield name;
                }
                yield TextUtils.CONTAINER;
            }
            case ShowcaseManager.ShareType.CONTAINER -> {
                class_2561 name = share.getInventory().getName();
                if (name != null) {
                    yield name;
                }
                yield TextUtils.CONTAINER;
            }
        };
    }

    private static String formatTime(long timestamp) {
        return TIME_FORMATTER.format(new Date(timestamp));
    }

    public static List<String> getPlayerNameCompletions(CommandContext<class_2168> ctx) {
        ArrayList<String> names = new ArrayList<String>();
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        if (server != null) {
            server.method_3760().method_14571().forEach(player -> names.add(player.method_5477().getString()));
        }
        return names;
    }

    @ApiStatus.Internal
    public static void handleError(CommandContext<class_2168> context, Throwable e) {
        if (e instanceof Error) {
            throw new Error("Unable to handle errors.", e);
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.failed").method_27693(":\n    " + e.getMessage()));
    }
}

